/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.base;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.XMLSerializer;
import org.w3c.dom.Document;

public class JDefinitionWriter {
    private File base;
    private Charset cs;
    private Definition definition;
    private String filename;
    private static Logger logger = Log.getLogger("org.ow2.jonas.ws");

    public JDefinitionWriter(Definition def, File context, Charset cs, String filename) {
        if (!context.exists()) {
            throw new IllegalArgumentException("Context MUST exists : " + context);
        }
        this.definition = def;
        this.base = context.isDirectory() ? context : context.getParentFile();
        this.cs = cs;
        this.filename = filename;
    }

    public void write() throws IOException, WSDLException {
        this.writeDefinition(this.definition, this.base, this.filename);
        Map imports = this.definition.getImports();
        for (String uri : imports.keySet()) {
            List importeds = (List)imports.get(uri);
            for (Import imported : importeds) {
                String locURI = imported.getLocationURI();
                if (locURI.startsWith("http://")) continue;
                Definition impDef = imported.getDefinition();
                if (locURI.toLowerCase().endsWith("wsdl")) {
                    JDefinitionWriter jdw = new JDefinitionWriter(impDef, new File(this.base, this.filename).getCanonicalFile(), this.cs, locURI);
                    jdw.write();
                    continue;
                }
                Types types = impDef.getTypes();
                if (types == null) continue;
                List extList = types.getExtensibilityElements();
                for (ExtensibilityElement ext : extList) {
                    Document doc = null;
                    if (ext instanceof Schema) {
                        Schema schema = (Schema)ext;
                        doc = schema.getElement().getOwnerDocument();
                    } else if (ext instanceof UnknownExtensibilityElement) {
                        UnknownExtensibilityElement unknownExtElem = (UnknownExtensibilityElement)ext;
                        doc = unknownExtElem.getElement().getOwnerDocument();
                    }
                    if (doc == null) continue;
                    File dir2 = new File(this.base, this.filename).getCanonicalFile().getParentFile();
                    this.writeDocument(doc, dir2, locURI);
                }
            }
        }
    }

    private void writeDocument(Document doc, File base, String locURI) throws IOException {
        XMLSerializer ser = new XMLSerializer(doc);
        File file = new File(base, locURI).getCanonicalFile();
        logger.log(BasicLevel.DEBUG, (Object)("Writing XML Document in " + file));
        this.createParentIfNeeded(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.cs);
        ser.serialize(writer);
        ((Writer)writer).close();
    }

    private void writeDefinition(Definition def, File base, String filename) throws WSDLException, IOException {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLWriter writer = factory.newWSDLWriter();
        File wsdl = new File(base, filename).getCanonicalFile();
        logger.log(BasicLevel.DEBUG, (Object)("Writing WSDL Definition in " + wsdl));
        this.createParentIfNeeded(wsdl);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(wsdl), this.cs);
        writer.writeWSDL(def, w);
        ((Writer)w).close();
    }

    private void createParentIfNeeded(File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            if (!parent.mkdirs()) {
                throw new IOException("Cannot create directory " + parent.getCanonicalPath());
            }
        } else if (!parent.isDirectory()) {
            throw new IOException("Parent " + parent.getCanonicalPath() + " already exists but is not a directory.");
        }
    }
}

