/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.archive;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.url.URLUtils;
import org.ow2.util.url.URLUtilsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarArchiveImpl
implements IArchive {
    private JarFile jarFile = null;
    private File file = null;

    protected JarArchiveImpl(File file) {
        this.file = file;
    }

    private void init() throws ArchiveException {
        try {
            this.jarFile = new JarFile(this.file);
        }
        catch (IOException e) {
            throw new ArchiveException("Invalid file", e);
        }
    }

    @Override
    public String getName() {
        return this.file.getPath();
    }

    @Override
    public boolean close() {
        if (this.jarFile == null) {
            return true;
        }
        try {
            this.jarFile.close();
        }
        catch (IOException e) {
            return false;
        }
        this.jarFile = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String resourceName) throws ArchiveException {
        URL url;
        block5: {
            url = null;
            this.init();
            try {
                JarEntry jarEntry = this.jarFile.getJarEntry(resourceName);
                if (jarEntry == null) break block5;
                try {
                    url = new URL("jar:" + URLUtils.fileToURL(this.file) + "!/" + resourceName);
                }
                catch (MalformedURLException e) {
                    throw new ArchiveException("Invalid url", e);
                }
            }
            finally {
                this.close();
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Iterator<URL> getResources() throws ArchiveException {
        ArrayList<URL> listResources = new ArrayList<URL>();
        this.init();
        try {
            Enumeration<JarEntry> en = this.jarFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                String name = zipEntry.getName();
                try {
                    listResources.add(new URL("jar:" + URLUtils.fileToURL(this.file) + "!/" + name));
                }
                catch (MalformedURLException e) {
                    throw new ArchiveException("Invalid url", e);
                    return listResources.iterator();
                }
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public Iterator<URL> getResources(String resourceName) throws ArchiveException {
        ArrayList<URL> listResources = new ArrayList<URL>();
        URL url = this.getResource(resourceName);
        if (url != null) {
            listResources.add(url);
        }
        return listResources.iterator();
    }

    @Override
    public URL getURL() throws ArchiveException {
        try {
            return URLUtils.fileToURL2(this.file);
        }
        catch (URLUtilsException e) {
            throw new ArchiveException("Invalid url", e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof JarArchiveImpl)) {
            return false;
        }
        JarArchiveImpl other = (JarArchiveImpl)o;
        return this.file.equals(other.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

