/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployable;

import java.util.HashMap;
import java.util.Map;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployableInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsDeployable<T>
implements IDeployable<T> {
    private IArchive archive = null;
    private T originalDeployable = null;
    private T unpackedDeployable = null;
    private Map<Class<? extends IDeployableInfo>, IDeployableInfo> extensions = null;

    public AbsDeployable(IArchive archive) {
        this.archive = archive;
        this.extensions = new HashMap<Class<? extends IDeployableInfo>, IDeployableInfo>();
    }

    @Override
    public IArchive getArchive() {
        return this.archive;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[archive=");
        sb.append(this.archive.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public T getOriginalDeployable() {
        return this.originalDeployable;
    }

    @Override
    public void setOriginalDeployable(T originalDeployable) {
        this.originalDeployable = originalDeployable;
    }

    @Override
    public T getUnpackedDeployable() {
        return this.unpackedDeployable;
    }

    @Override
    public void setUnpackedDeployable(T unpackedDeployable) {
        this.unpackedDeployable = unpackedDeployable;
    }

    @Override
    public void addExtension(IDeployableInfo extension) {
        this.extensions.put(extension.getClass(), extension);
    }

    @Override
    public IDeployableInfo getExtension(Class<? extends IDeployableInfo> extensionClass) {
        return this.extensions.get(extensionClass);
    }
}

