/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.execution.helper;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.ow2.util.execution.ExecutionResult;
import org.ow2.util.execution.IExecution;
import org.ow2.util.execution.IRunner;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RunnableHelper<T>
implements IRunner<T> {
    private Log logger = LogFactory.getLog(RunnableHelper.class);

    private static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult<T> execute(ClassLoader loader, IExecution<T> exec) {
        ExecutionResult<T> result = new ExecutionResult<T>();
        ClassLoader old = RunnableHelper.getThreadContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            result.setResult(exec.execute());
        }
        catch (Exception e) {
            this.logger.debug("IExecution produced Exception: {0}", e.getMessage());
            result.setException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        return result;
    }
}

