/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzInitializerListener
implements ServletContextListener {
    public static final String QUARTZ_FACTORY_KEY = "org.quartz.impl.StdSchedulerFactory.KEY";
    private boolean performShutdown = true;
    private Scheduler scheduler = null;

    public void contextInitialized(ServletContextEvent sce) {
        System.out.println("Quartz Initializer Servlet loaded, initializing Scheduler...");
        ServletContext servletContext = sce.getServletContext();
        try {
            String configFile = servletContext.getInitParameter("config-file");
            String shutdownPref = servletContext.getInitParameter("shutdown-on-unload");
            if (shutdownPref != null) {
                this.performShutdown = Boolean.valueOf(shutdownPref);
            }
            StdSchedulerFactory factory = configFile != null ? new StdSchedulerFactory(configFile) : new StdSchedulerFactory();
            this.scheduler = factory.getScheduler();
            String startOnLoad = servletContext.getInitParameter("start-scheduler-on-load");
            if (startOnLoad == null || Boolean.valueOf(startOnLoad).booleanValue()) {
                this.scheduler.start();
                System.out.println("Scheduler has been started...");
            } else {
                System.out.println("Scheduler has not been started. Use scheduler.start()");
            }
            String factoryKey = servletContext.getInitParameter("servlet-context-factory-key");
            if (factoryKey == null) {
                factoryKey = QUARTZ_FACTORY_KEY;
            }
            System.out.println("Storing the Quartz Scheduler Factory in the servlet context at key: " + factoryKey);
            servletContext.setAttribute(factoryKey, factory);
        }
        catch (Exception e) {
            System.out.println("Quartz Scheduler failed to initialize: " + e.toString());
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (!this.performShutdown) {
            return;
        }
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
        }
        catch (Exception e) {
            System.out.println("Quartz Scheduler failed to shutdown cleanly: " + e.toString());
            e.printStackTrace();
        }
        System.out.println("Quartz Scheduler successful shutdown.");
    }
}

