/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.jobs;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.StatefulJob;
import org.quartz.jobs.FileScanListener;

public class FileScanJob
implements StatefulJob {
    public static String FILE_NAME = "FILE_NAME";
    public static String FILE_SCAN_LISTENER_NAME = "FILE_SCAN_LISTENER_NAME";
    private static String LAST_MODIFIED_TIME = "LAST_MODIFIED_TIME";
    private final Log log = LogFactory.getLog(this.getClass());

    public void execute(JobExecutionContext context) throws JobExecutionException {
        long newDate;
        JobDataMap mergedJobDataMap = context.getMergedJobDataMap();
        SchedulerContext schedCtxt = null;
        try {
            schedCtxt = context.getScheduler().getContext();
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Error obtaining scheduler context.", (Throwable)e, false);
        }
        String fileName = mergedJobDataMap.getString(FILE_NAME);
        String listenerName = mergedJobDataMap.getString(FILE_SCAN_LISTENER_NAME);
        if (fileName == null) {
            throw new JobExecutionException("Required parameter '" + FILE_NAME + "' not found in merged JobDataMap");
        }
        if (listenerName == null) {
            throw new JobExecutionException("Required parameter '" + FILE_SCAN_LISTENER_NAME + "' not found in merged JobDataMap");
        }
        FileScanListener listener = (FileScanListener)schedCtxt.get(listenerName);
        if (listener == null) {
            throw new JobExecutionException("FileScanListener named '" + listenerName + "' not found in SchedulerContext");
        }
        long lastDate = -1L;
        if (mergedJobDataMap.containsKey(LAST_MODIFIED_TIME)) {
            lastDate = mergedJobDataMap.getLong(LAST_MODIFIED_TIME);
        }
        if ((newDate = this.getLastModifiedDate(fileName)) < 0L) {
            this.log.warn("File '" + fileName + "' does not exist.");
            return;
        }
        if (lastDate > 0L && newDate != lastDate) {
            this.log.info("File '" + fileName + "' updated, notifying listener.");
            listener.fileUpdated(fileName);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("File '" + fileName + "' unchanged.");
        }
        context.getJobDetail().getJobDataMap().put(LAST_MODIFIED_TIME, newDate);
    }

    protected long getLastModifiedDate(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return -1L;
        }
        return file.lastModified();
    }
}

