/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;

public class SimpleThreadPool
implements ThreadPool {
    private int count = -1;
    private int prio = 5;
    private boolean isShutdown = false;
    private boolean handoffPending = false;
    private boolean inheritLoader = false;
    private boolean inheritGroup = true;
    private boolean makeThreadsDaemons = false;
    private ThreadGroup threadGroup;
    private final Object nextRunnableLock = new Object();
    private List workers;
    private LinkedList availWorkers = new LinkedList();
    private LinkedList busyWorkers = new LinkedList();
    private String threadNamePrefix = "SimpleThreadPoolWorker";
    private final Log log = LogFactory.getLog(this.getClass());

    public SimpleThreadPool() {
    }

    public SimpleThreadPool(int threadCount, int threadPriority) {
        this.setThreadCount(threadCount);
        this.setThreadPriority(threadPriority);
    }

    public Log getLog() {
        return this.log;
    }

    public int getPoolSize() {
        return this.getThreadCount();
    }

    public void setThreadCount(int count) {
        this.count = count;
    }

    public int getThreadCount() {
        return this.count;
    }

    public void setThreadPriority(int prio) {
        this.prio = prio;
    }

    public int getThreadPriority() {
        return this.prio;
    }

    public void setThreadNamePrefix(String prfx) {
        this.threadNamePrefix = prfx;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public boolean isThreadsInheritContextClassLoaderOfInitializingThread() {
        return this.inheritLoader;
    }

    public void setThreadsInheritContextClassLoaderOfInitializingThread(boolean inheritLoader) {
        this.inheritLoader = inheritLoader;
    }

    public boolean isThreadsInheritGroupOfInitializingThread() {
        return this.inheritGroup;
    }

    public void setThreadsInheritGroupOfInitializingThread(boolean inheritGroup) {
        this.inheritGroup = inheritGroup;
    }

    public boolean isMakeThreadsDaemons() {
        return this.makeThreadsDaemons;
    }

    public void setMakeThreadsDaemons(boolean makeThreadsDaemons) {
        this.makeThreadsDaemons = makeThreadsDaemons;
    }

    public void initialize() throws SchedulerConfigException {
        if (this.count <= 0) {
            throw new SchedulerConfigException("Thread count must be > 0");
        }
        if (this.prio <= 0 || this.prio > 9) {
            throw new SchedulerConfigException("Thread priority must be > 0 and <= 9");
        }
        if (this.isThreadsInheritGroupOfInitializingThread()) {
            this.threadGroup = Thread.currentThread().getThreadGroup();
        } else {
            ThreadGroup parent = this.threadGroup = Thread.currentThread().getThreadGroup();
            while (!parent.getName().equals("main")) {
                this.threadGroup = parent;
                parent = this.threadGroup.getParent();
            }
            this.threadGroup = new ThreadGroup(parent, "SimpleThreadPool");
            if (this.isMakeThreadsDaemons()) {
                this.threadGroup.setDaemon(true);
            }
        }
        if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
            this.getLog().info("Job execution threads will use class loader of thread: " + Thread.currentThread().getName());
        }
        Iterator workerThreads = this.createWorkerThreads(this.count).iterator();
        while (workerThreads.hasNext()) {
            WorkerThread wt = (WorkerThread)workerThreads.next();
            wt.start();
            this.availWorkers.add(wt);
        }
    }

    protected List createWorkerThreads(int count) {
        this.workers = new LinkedList();
        for (int i = 1; i <= count; ++i) {
            WorkerThread wt = new WorkerThread(this, this.threadGroup, this.getThreadNamePrefix() + "-" + i, this.getThreadPriority(), this.isMakeThreadsDaemons());
            if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
                wt.setContextClassLoader(Thread.currentThread().getContextClassLoader());
            }
            this.workers.add(wt);
        }
        return this.workers;
    }

    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean waitForJobsToComplete) {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            WorkerThread wt;
            this.isShutdown = true;
            Iterator workerThreads = this.workers.iterator();
            while (workerThreads.hasNext()) {
                wt = (WorkerThread)workerThreads.next();
                wt.shutdown();
                this.availWorkers.remove(wt);
            }
            this.nextRunnableLock.notifyAll();
            if (waitForJobsToComplete) {
                while (this.handoffPending) {
                    try {
                        this.nextRunnableLock.wait(100L);
                    }
                    catch (Throwable t) {}
                }
                while (this.busyWorkers.size() > 0) {
                    wt = (WorkerThread)this.busyWorkers.getFirst();
                    try {
                        this.getLog().debug("Waiting for thread " + wt.getName() + " to shut down");
                        this.nextRunnableLock.wait(2000L);
                    }
                    catch (InterruptedException ex) {}
                }
                int activeCount = this.threadGroup.activeCount();
                if (activeCount > 0) {
                    this.getLog().info("There are still " + activeCount + " worker threads active." + " See javadoc runInThread(Runnable) for a possible explanation");
                }
                this.getLog().debug("shutdown complete");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runInThread(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        Object object = this.nextRunnableLock;
        synchronized (object) {
            this.handoffPending = true;
            while (this.availWorkers.size() < 1 && !this.isShutdown) {
                try {
                    this.nextRunnableLock.wait(500L);
                }
                catch (InterruptedException ignore) {}
            }
            if (!this.isShutdown) {
                WorkerThread wt = (WorkerThread)this.availWorkers.removeFirst();
                this.busyWorkers.add(wt);
                wt.run(runnable);
            } else {
                WorkerThread wt = new WorkerThread(this, this.threadGroup, "WorkerThread-LastJob", this.prio, this.isMakeThreadsDaemons(), runnable);
                this.busyWorkers.add(wt);
                this.workers.add(wt);
                wt.start();
            }
            this.nextRunnableLock.notifyAll();
            this.handoffPending = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int blockForAvailableThreads() {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            while ((this.availWorkers.size() < 1 || this.handoffPending) && !this.isShutdown) {
                try {
                    this.nextRunnableLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.availWorkers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeAvailable(WorkerThread wt) {
        Object object = this.nextRunnableLock;
        synchronized (object) {
            if (!this.isShutdown) {
                this.availWorkers.add(wt);
            }
            this.busyWorkers.remove(wt);
            this.nextRunnableLock.notifyAll();
        }
    }

    class WorkerThread
    extends Thread {
        private boolean run = true;
        private SimpleThreadPool tp;
        private Runnable runnable = null;

        WorkerThread(SimpleThreadPool tp, ThreadGroup threadGroup, String name, int prio, boolean isDaemon) {
            this(tp, threadGroup, name, prio, isDaemon, null);
        }

        WorkerThread(SimpleThreadPool tp, ThreadGroup threadGroup, String name, int prio, boolean isDaemon, Runnable runnable) {
            super(threadGroup, name);
            this.tp = tp;
            this.runnable = runnable;
            this.setPriority(prio);
            this.setDaemon(isDaemon);
        }

        void shutdown() {
            this.run = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Runnable newRunnable) {
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                if (this.runnable != null) {
                    throw new IllegalStateException("Already running a Runnable!");
                }
                this.runnable = newRunnable;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean runOnce = this.runnable != null;
            boolean ran = false;
            while (this.run) {
                Object var6_10;
                try {
                    block23: {
                        try {
                            WorkerThread workerThread = this;
                            synchronized (workerThread) {
                                while (this.runnable == null && this.run) {
                                    this.wait(500L);
                                }
                                if (this.runnable == null) break block23;
                            }
                            ran = true;
                            this.runnable.run();
                        }
                        catch (InterruptedException unblock) {
                            try {
                                SimpleThreadPool.this.getLog().error("worker threat got 'interrupt'ed.", unblock);
                            }
                            catch (Exception e) {
                            }
                            var6_10 = null;
                            this.runnable = null;
                            if (this.getPriority() != this.tp.getThreadPriority()) {
                                this.setPriority(this.tp.getThreadPriority());
                            }
                            if (runOnce) {
                                this.run = false;
                                continue;
                            }
                            if (!ran) continue;
                            ran = false;
                            SimpleThreadPool.this.makeAvailable(this);
                            continue;
                        }
                        catch (Exception exceptionInRunnable) {
                            try {
                                SimpleThreadPool.this.getLog().error("Error while executing the Runnable: ", exceptionInRunnable);
                            }
                            catch (Exception e) {
                            }
                            var6_10 = null;
                            this.runnable = null;
                            if (this.getPriority() != this.tp.getThreadPriority()) {
                                this.setPriority(this.tp.getThreadPriority());
                            }
                            if (runOnce) {
                                this.run = false;
                                continue;
                            }
                            if (!ran) continue;
                            ran = false;
                            SimpleThreadPool.this.makeAvailable(this);
                            continue;
                        }
                    }
                    var6_10 = null;
                    this.runnable = null;
                }
                catch (Throwable throwable) {
                    var6_10 = null;
                    this.runnable = null;
                    if (this.getPriority() != this.tp.getThreadPriority()) {
                        this.setPriority(this.tp.getThreadPriority());
                    }
                    if (runOnce) {
                        this.run = false;
                        throw throwable;
                    }
                    if (!ran) throw throwable;
                    ran = false;
                    SimpleThreadPool.this.makeAvailable(this);
                    throw throwable;
                }
                if (this.getPriority() != this.tp.getThreadPriority()) {
                    this.setPriority(this.tp.getThreadPriority());
                }
                if (runOnce) {
                    this.run = false;
                    continue;
                }
                if (!ran) continue;
                ran = false;
                SimpleThreadPool.this.makeAvailable(this);
            }
            try {
                SimpleThreadPool.this.getLog().debug("WorkerThread is shutting down");
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

