/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genclientstub.modifier;

import java.util.ArrayList;
import java.util.List;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.genbase.modifier.ArchiveModifier;
import org.ow2.jonas.generators.genclientstub.ClientStubGenException;
import org.ow2.jonas.generators.genclientstub.generator.Generator;

public abstract class AbsArchiveModifier
extends ArchiveModifier {
    public AbsArchiveModifier(J2EEArchive archive) {
        super(archive);
    }

    public abstract Archive modify() throws GenBaseException;

    protected void generateFoundStubs(Config config, Archive archive) throws ClientStubGenException {
        ArrayList<String> classesStub = new ArrayList<String>();
        try {
            List files = archive.getContainedFiles();
            for (String clName : files) {
                if (!clName.endsWith("_Stub.class") && !clName.endsWith("_Tie.class")) continue;
                if (archive instanceof WebApp) {
                    if (!clName.startsWith("WEB-INF/classes/")) continue;
                    classesStub.add(clName.substring("WEB-INF/classes/".length()));
                    continue;
                }
                classesStub.add(clName);
            }
            for (String clName : classesStub) {
                int removeStubIdx = 0;
                if (clName.endsWith("_Stub.class")) {
                    removeStubIdx = clName.length() - "_Stub.class".length();
                } else {
                    if (!clName.endsWith("_Tie.class")) continue;
                    removeStubIdx = clName.length() - "_Tie.class".length();
                }
                clName = clName.substring(0, removeStubIdx);
                int idx = clName.lastIndexOf(47) + 1;
                if (clName.charAt(idx) == '_') {
                    String pkgName = clName.substring(0, idx);
                    clName = pkgName + clName.substring(idx + 1, clName.length());
                }
                if ((clName = clName.replaceAll("/", ".")).indexOf("javax.") != -1 || clName.indexOf("org.omg.stub") != -1 || clName.indexOf("Home") != -1 || clName.indexOf("Remote") != -1) continue;
                Generator g = new Generator(config, null, clName, archive);
                try {
                    g.generate();
                    g.compile();
                }
                catch (ClientStubGenException cstge) {
                    continue;
                }
                g.addFiles(archive);
            }
        }
        catch (Exception e) {
            throw new ClientStubGenException("Cannot find/build stubs from the file " + archive.getRootFile(), e);
        }
    }
}

