/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.omg.CORBA.portable.InputStream;

public class IIOPAddress
extends ProtocolAddressBase {
    private String source_name = null;
    private InetAddress host = null;
    private int port = -1;
    private boolean unresolvable = false;
    private boolean dnsEnabled = false;
    private Logger logger;

    public IIOPAddress(String string, int n) {
        this.source_name = string;
        this.port = n < 0 ? n + 65536 : n;
    }

    public IIOPAddress() {
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.logger = this.configuration.getNamedLogger("jacorb.iiop.address");
        this.dnsEnabled = configuration.getAttribute("jacorb.dns.enable", "off").equals("on");
    }

    private void init_host() {
        Object object;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            object = new byte[]{127, 0, 0, 1};
            try {
                inetAddress = InetAddress.getByAddress("127.0.0.1", object);
            }
            catch (UnknownHostException unknownHostException2) {
                // empty catch block
            }
        }
        if (this.source_name == null || this.source_name.length() == 0) {
            this.host = inetAddress;
        } else {
            String string = null;
            object = null;
            int n = this.source_name.indexOf(47);
            if (n == -1) {
                object = this.source_name;
            } else {
                object = this.source_name.substring(n + 1);
                if (n > 0) {
                    string = this.source_name.substring(0, n);
                }
            }
            byte[] byArray = new byte[4];
            try {
                this.host = this.dnsEnabled || !IIOPAddress.isIP((String)object, byArray) ? InetAddress.getByName((String)object) : InetAddress.getByAddress(byArray);
            }
            catch (UnknownHostException unknownHostException) {
                if (this.logger != null && this.logger.isWarnEnabled()) {
                    this.logger.warn("init_host, " + this.source_name + " unresolvable");
                }
                this.unresolvable = true;
                try {
                    this.host = InetAddress.getByAddress(this.source_name, inetAddress.getAddress());
                }
                catch (UnknownHostException unknownHostException3) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean isIP(String string, byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 32;
        for (int i = 0; i < 4; ++i) {
            int n5 = 0;
            while (n < n3 && (n4 = (int)string.charAt(n)) != 46) {
                if (n4 < 48 || n4 > 57) {
                    return false;
                }
                n5 = n5 * 10 + (n4 - 48);
                ++n;
            }
            if (n5 >= 256) {
                return false;
            }
            byArray[i] = (byte)n5;
            if (n >= n3 && i == 3 && n - n2 <= 3 && n - n2 > 0) {
                return true;
            }
            if (n4 != 46 || n - n2 > 3 || n - n2 <= 0) {
                return false;
            }
            n2 = ++n;
        }
        return false;
    }

    public static IIOPAddress read(InputStream inputStream) {
        String string = inputStream.read_string();
        short s = inputStream.read_ushort();
        IIOPAddress iIOPAddress = new IIOPAddress(string, s);
        return iIOPAddress;
    }

    public String getIP() {
        if (this.host == null) {
            this.init_host();
        }
        if (this.unresolvable) {
            return this.source_name;
        }
        return this.host.getHostAddress();
    }

    public String getHostname() {
        if (this.host == null) {
            this.init_host();
        }
        if (this.unresolvable) {
            return this.source_name;
        }
        return this.dnsEnabled ? this.host.getCanonicalHostName() : this.host.getHostAddress();
    }

    public void setHostname(String string) {
        this.host = null;
        this.source_name = string;
    }

    public InetAddress getConfiguredHost() {
        if (this.source_name == null || this.source_name.length() == 0) {
            return null;
        }
        if (this.host == null) {
            this.init_host();
        }
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public boolean equals(Object object) {
        if (object instanceof IIOPAddress) {
            IIOPAddress iIOPAddress = (IIOPAddress)object;
            if (this.port == iIOPAddress.port) {
                return this.source_name.equals(iIOPAddress.source_name);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.source_name != null) {
            return this.source_name.hashCode() + this.port;
        }
        if (this.host != null) {
            return this.host.hashCode() + this.port;
        }
        return this.port;
    }

    public String toString() {
        return this.getHostname() + ":" + this.port;
    }

    public boolean fromString(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return false;
        }
        this.source_name = null;
        int n2 = 0;
        this.source_name = n > 0 ? string.substring(0, n) : "";
        if (n < string.length() - 1) {
            n2 = Integer.parseInt(string.substring(n + 1));
        }
        this.init_host();
        this.port = n2 < 0 ? n2 + 65536 : n2;
        return true;
    }

    public void write(CDROutputStream cDROutputStream) {
        cDROutputStream.write_string(this.getHostname());
        cDROutputStream.write_ushort((short)this.port);
    }

    public static IIOPAddress read(CDRInputStream cDRInputStream) {
        String string = cDRInputStream.read_string();
        short s = cDRInputStream.read_ushort();
        return new IIOPAddress(string, s);
    }

    public String getOriginalHost() {
        if (this.source_name == null) {
            if (!this.dnsEnabled) {
                return this.getIP();
            }
            return this.getHostname() + " / " + this.getIP();
        }
        return this.source_name;
    }

    void replaceFrom(IIOPAddress iIOPAddress) {
        if (iIOPAddress.source_name != null) {
            this.setHostname(iIOPAddress.source_name);
        }
        if (iIOPAddress.port != -1) {
            this.setPort(iIOPAddress.port);
        }
    }
}

