/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;

public class SHARED_LOOPBACK
extends TP {
    private static int next_port = 10000;
    private static final Map<String, Map<Address, SHARED_LOOPBACK>> routing_table = new ConcurrentHashMap<String, Map<Address, SHARED_LOOPBACK>>();

    public String toString() {
        return "SHARED_LOOPBACK(local address: " + this.local_addr + ')';
    }

    public void sendToAllMembers(byte[] data, int offset, int length) throws Exception {
        Map<Address, SHARED_LOOPBACK> dests = routing_table.get(this.channel_name);
        if (dests == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("no destination found for " + this.channel_name));
            }
            return;
        }
        for (Map.Entry<Address, SHARED_LOOPBACK> entry : dests.entrySet()) {
            Address dest = entry.getKey();
            SHARED_LOOPBACK target = entry.getValue();
            try {
                target.receive(dest, this.local_addr, data, offset, length);
            }
            catch (Throwable t) {
                this.log.error((Object)("failed sending message to " + dest), t);
            }
        }
    }

    public void sendToSingleMember(Address dest, byte[] data, int offset, int length) throws Exception {
        Map<Address, SHARED_LOOPBACK> dests = routing_table.get(this.channel_name);
        if (dests == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("no destination found for " + this.channel_name));
            }
            return;
        }
        SHARED_LOOPBACK target = dests.get(dest);
        if (target == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("destination address " + dest + " not found"));
            }
            return;
        }
        target.receive(dest, this.local_addr, data, offset, length);
    }

    public String getInfo() {
        return this.toString();
    }

    public void postUnmarshalling(Message msg, Address dest, Address src, boolean multicast) {
    }

    public void postUnmarshallingList(Message msg, Address dest, boolean multicast) {
    }

    public String getName() {
        return "SHARED_LOOPBACK";
    }

    public void init() throws Exception {
        this.local_addr = new IpAddress("127.0.0.1", next_port++);
        super.init();
    }

    public void start() throws Exception {
        super.start();
    }

    public void stop() {
        super.stop();
    }

    public Object down(Event evt) {
        Object retval = super.down(evt);
        switch (evt.getType()) {
            case 2: 
            case 80: {
                this.register(this.channel_name, this.local_addr, this);
                break;
            }
            case 4: {
                this.unregister(this.channel_name, this.local_addr);
            }
        }
        return retval;
    }

    private void register(String channel_name, Address local_addr, SHARED_LOOPBACK shared_loopback) {
        Map<Address, SHARED_LOOPBACK> map = routing_table.get(channel_name);
        if (map == null) {
            map = new ConcurrentHashMap<Address, SHARED_LOOPBACK>();
            routing_table.put(channel_name, map);
        }
        map.put(local_addr, shared_loopback);
    }

    private void unregister(String channel_name, Address local_addr) {
        Map<Address, SHARED_LOOPBACK> map = routing_table.get(channel_name);
        if (map != null) {
            map.remove(local_addr);
            if (map.isEmpty()) {
                routing_table.remove(channel_name);
            }
        }
    }
}

