/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.HashMap;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.stack.IpAddress;

public class AddDataTest
extends TestCase {
    JChannel ch1;
    JChannel ch2;
    String properties = "udp.xml";
    String bundlingProperties = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32;enable_bundling=true;max_bundle_size=3000;max_bundle_timeout=500):PING(timeout=2000;num_initial_members=2):pbcast.NAKACK(gc_lag=10;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.GMS(join_timeout=5000;shun=true;print_local_addr=true)";

    public AddDataTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.ch2 != null) {
            this.ch2.close();
        }
        if (this.ch1 != null) {
            this.ch1.close();
        }
    }

    public void testAdditionalData() {
        try {
            for (int i = 1; i <= 5; ++i) {
                System.out.println("-- attempt # " + i + "/10");
                JChannel c = new JChannel(this.properties);
                HashMap<String, byte[]> m = new HashMap<String, byte[]>();
                m.put("additional_data", new byte[]{98, 101, 108, 97});
                c.down(new Event(56, m));
                c.connect("bla");
                IpAddress addr = (IpAddress)c.getLocalAddress();
                System.out.println("address is " + addr);
                AddDataTest.assertNotNull((Object)addr.getAdditionalData());
                AddDataTest.assertEquals((int)98, (int)addr.getAdditionalData()[0]);
                c.close();
            }
        }
        catch (ChannelException e) {
            e.printStackTrace();
            AddDataTest.fail((String)e.toString());
        }
    }

    public void testBetweenTwoChannelsMcast() throws Exception {
        this._testWithProps(this.properties, true);
    }

    public void testBetweenTwoChannelsUnicast() throws Exception {
        this._testWithProps(this.properties, false);
    }

    public void testBetweenTwoChannelsWithBundlingMcast() throws Exception {
        this._testWithProps(this.bundlingProperties, true);
    }

    public void testBetweenTwoChannelsWithBundlingUnicast() throws Exception {
        this._testWithProps(this.bundlingProperties, false);
    }

    private void _testWithProps(String props, boolean mcast) throws Exception {
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put("additional_data", new byte[]{98, 101, 108, 97});
        byte[] buf = new byte[1000];
        this.ch1 = new JChannel(props);
        this.ch1.down(new Event(56, m));
        this.ch2 = new JChannel(props);
        this.ch2.down(new Event(56, m));
        this.ch1.connect("group");
        this.ch2.connect("group");
        while (this.ch2.peek(10L) != null) {
            System.out.println("-- received " + this.ch2.receive(100L));
        }
        if (mcast) {
            this.ch1.send(new Message(null, null, buf));
        } else {
            Address dest = this.ch2.getLocalAddress();
            this.ch1.send(new Message(dest, null, buf));
        }
        Message msg = (Message)this.ch2.receive(10000L);
        System.out.println("received " + msg);
        IpAddress src = (IpAddress)msg.getSrc();
        System.out.println("src=" + src);
        AddDataTest.assertNotNull((Object)src);
        AddDataTest.assertNotNull((Object)src.getAdditionalData());
        AddDataTest.assertEquals((int)4, (int)src.getAdditionalData().length);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{AddDataTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }
}

