/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jgroups.util.Util;

public class DatagramTest {
    DatagramSocket sock;

    private void start(boolean sender, InetAddress host, int port, int num_packets, int size, long sleep, int buffer_size) throws Exception {
        if (sender) {
            this.sock = new DatagramSocket();
            if (buffer_size > 0) {
                this.sock.setSendBufferSize(buffer_size);
            }
            System.out.println("local socket is " + this.sock.getLocalSocketAddress() + ", send buffer size=" + this.sock.getSendBufferSize());
            this.sendPackets(num_packets, size, host, port, sleep);
        } else {
            this.sock = new DatagramSocket(new InetSocketAddress(host, port));
            if (buffer_size > 0) {
                this.sock.setReceiveBufferSize(buffer_size);
            }
            System.out.println("receive buffer size=" + this.sock.getReceiveBufferSize());
            System.out.println("listening on " + this.sock.getLocalSocketAddress());
            this.loop();
        }
    }

    private void loop() throws IOException {
        byte[] buf = new byte[70000];
        int count = 0;
        while (true) {
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            this.sock.receive(packet);
            System.out.print("received " + ++count + " packets\r");
        }
    }

    private void sendPackets(int num_packets, int size, InetAddress host, int port, long sleep) throws Exception {
        byte[] buf = new byte[size];
        int print = num_packets / 10;
        for (int i = 0; i < num_packets; ++i) {
            DatagramPacket packet = new DatagramPacket(buf, buf.length, host, port);
            this.sock.send(packet);
            if (print == 0 || i % print == 0) {
                System.out.print("sent " + i + " messages\r");
            }
            if (sleep <= 0L) continue;
            Util.sleep(sleep);
        }
    }

    public static void main(String[] args) throws Exception {
        boolean sender = false;
        InetAddress host = null;
        int port = 5000;
        int num_packets = 10000;
        int size = 1000;
        long sleep = 0L;
        int buf = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-sender")) {
                sender = true;
                continue;
            }
            if (args[i].equals("-host")) {
                host = InetAddress.getByName(args[++i]);
                continue;
            }
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-num_packets")) {
                num_packets = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-size")) {
                size = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-sleep")) {
                sleep = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-buf")) {
                buf = Integer.parseInt(args[++i]);
                continue;
            }
            DatagramTest.help();
            return;
        }
        if (host == null) {
            host = InetAddress.getByName("localhost");
        }
        new DatagramTest().start(sender, host, port, num_packets, size, sleep, buf);
    }

    private static void help() {
        System.out.println("DatagramTest [-help] [-sender] [-host] [-port] [-num_packets <num>] [-size <size>] [-sleep <ms>] [-buf <buf in bytes>]");
    }
}

