/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.jorm;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.objectweb.jorm.api.JormConfigurator;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.lib.JormConfiguratorImpl;
import org.objectweb.jorm.lib.Mapper;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.medor.eval.prefetch.api.PrefetchCache;
import org.objectweb.medor.eval.prefetch.lib.PrefetchCacheImpl;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.TraceEjb;

public class MapperManager {
    private static MapperManager singleton = null;
    private Logger logger = null;
    private HashMap mappers = new HashMap();
    private JormConfigurator jormConfigurator;

    public static MapperManager getInstance() {
        if (singleton == null) {
            singleton = new MapperManager();
        }
        return singleton;
    }

    protected MapperManager() {
        this.logger = TraceEjb.logger;
        this.jormConfigurator = new JormConfiguratorImpl();
        Properties prop = new Properties();
        prop.put("jorm.generator", "org.objectweb.jorm.generator.lib.JormGenerator");
        prop.put("jorm.mimanager", "org.objectweb.jorm.metainfo.lib.JormManager");
        prop.put("jorm.parser", "org.objectweb.jorm.xml2mi.lib.BasicDomParser");
        prop.put("jorm.verifier", "org.objectweb.jorm.verifier.lib.JormVerifier");
        prop.put("jorm.writer", "org.objectweb.jorm.mi2xml.lib.BasicDomWriter");
        prop.put("jorm.mapper.list", "rdb");
        prop.put("jorm.mapper.mifactory.rdb", "org.objectweb.jorm.mapper.rdb.metainfo.RdbMappingFactory");
        prop.put("jorm.mapper.mopfactory.rdb", "org.objectweb.jorm.mapper.rdb.generator.RdbMOPFactory");
        prop.put("jorm.mapper.gcmapping.rdb", "org.objectweb.jorm.mapper.rdb.genclass.RdbGenClassMapping");
        prop.put("jorm.mapper.schmgr.rdb", "org.objectweb.jorm.mapper.rdb.lib.RdbPMappingStructuresManager");
        this.jormConfigurator.configure(prop);
        this.jormConfigurator.setLoggerFactory(TraceEjb.loggerFactory);
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)"JormConfigurator created");
        }
    }

    public PMapper getMapper(JContainer c, Object cf) {
        Map m = (Map)this.mappers.get(c);
        return m == null ? null : (Mapper)m.get(cf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PMapper addMapper(PMapper m, JContainer c, Object cf) throws PException {
        HashMap<Object, PMapper> map;
        PMapper pm = null;
        HashMap<Object, PMapper> hashMap = this.mappers;
        synchronized (hashMap) {
            map = (HashMap<Object, PMapper>)this.mappers.get(c);
            if (map == null) {
                map = new HashMap<Object, PMapper>();
                this.mappers.put(c, map);
            }
        }
        pm = (PMapper)map.get(cf);
        if (pm != null) {
            return pm;
        }
        hashMap = map;
        synchronized (hashMap) {
            pm = (PMapper)map.get(cf);
            if (pm == null) {
                pm = m;
                m.setPrefetchCache((PrefetchCache)new PrefetchCacheImpl(this.logger));
                if (TraceEjb.loggerFactory == null) {
                    m.setLogger(this.logger);
                } else {
                    m.setLogger(TraceEjb.loggerFactory.getLogger("org.ow2.jonas.lib.ejb21.mapper." + m.getMapperName()));
                    if (m instanceof Loggable) {
                        ((Loggable)m).setLoggerFactory(TraceEjb.loggerFactory);
                    }
                }
                m.start();
                map.put(cf, m);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Mapper (" + m.getMapperName() + ", " + cf + ") initialized"));
                }
            }
        }
        return pm;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public JormConfigurator getJormConfigurator() {
        return this.jormConfigurator;
    }
}

