/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.security.lib.wrapper;

import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.security.internal.JResources;
import org.ow2.jonas.security.internal.SecurityServiceException;

public class JResourceManagerWrapper {
    private static Object managerInstance = null;
    private static Method addResourcesMethod = null;

    private JResourceManagerWrapper() {
    }

    public static void addResources(JResources jres, Reader reader, String xml) throws SecurityServiceException {
        if (managerInstance == null) {
            managerInstance = JResourceManagerWrapper.getJResourceManagerInstance();
        }
        if (addResourcesMethod == null) {
            addResourcesMethod = JResourceManagerWrapper.getJResourceManagerMethod();
        }
        try {
            addResourcesMethod.invoke(managerInstance, jres, reader, xml);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof SecurityServiceException) {
                throw (SecurityServiceException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new SecurityServiceException("Exception during JResourcesManager.addResources invocation", e);
        }
        catch (Exception e) {
            throw new SecurityServiceException("Exception during JResourcesManager.addResources invocation", e);
        }
    }

    private static Method getJResourceManagerMethod() throws SecurityServiceException {
        try {
            return managerInstance.getClass().getMethod("addResources", JResources.class, Reader.class, String.class);
        }
        catch (Exception e) {
            throw new SecurityServiceException("Cannot get JResourcesManager.addResources method", e);
        }
    }

    private static Object getJResourceManagerInstance() throws SecurityServiceException {
        LoaderManager lm = LoaderManager.getInstance();
        try {
            JClassLoader tools = lm.getToolsLoader();
            Class<?> jrmClass = tools.loadClass("org.ow2.jonas.security.lib.JResourceManager");
            Method m = jrmClass.getMethod("getInstance", new Class[0]);
            return m.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof SecurityServiceException) {
                throw (SecurityServiceException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new SecurityServiceException("InvocationTargetException during JResourcesManager.getInstance invocation : " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new SecurityServiceException("Exception during JResourcesManager.getInstance invocation : " + e.getMessage(), e);
        }
    }
}

