/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.gui.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import org.apache.felix.shell.gui.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class BundleListPlugin
extends JPanel
implements Plugin {
    private BundleContext m_context = null;
    private JTextField m_urlField = null;
    private JButton m_installButton = null;
    private JTable m_bundleTable = null;
    private JButton m_startButton = null;
    private JButton m_stopButton = null;
    private JButton m_updateButton = null;
    private JButton m_refreshButton = null;
    private JButton m_uninstallButton = null;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;

    public String getName() {
        return "Bundle List";
    }

    public Component getGUI() {
        return this;
    }

    public BundleListPlugin(BundleContext context) {
        this.m_context = context;
        this.setLayout(new BorderLayout());
        JScrollPane scroll = null;
        this.add((Component)this.createURLPanel(), "North");
        this.m_bundleTable = new JTable();
        scroll = new JScrollPane(this.m_bundleTable);
        this.add((Component)scroll, "Center");
        this.add((Component)this.createButtonPanel(), "South");
        this.m_bundleTable.setAutoResizeMode(3);
        this.m_bundleTable.setModel(new SimpleTableModel());
        this.m_bundleTable.getColumnModel().getColumn(0).setPreferredWidth(75);
        this.m_bundleTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.m_bundleTable.getColumnModel().getColumn(2).setPreferredWidth(350);
        this.createEventListeners();
    }

    private JPanel createURLPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("URL"), "West");
        this.m_urlField = new JTextField(20);
        panel.add((Component)this.m_urlField, "Center");
        this.m_installButton = new JButton("Install");
        panel.add((Component)this.m_installButton, "East");
        this.m_installButton.setMnemonic('I');
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        this.m_startButton = new JButton("Start");
        panel.add(this.m_startButton);
        this.m_stopButton = new JButton("Stop");
        panel.add(this.m_stopButton);
        this.m_updateButton = new JButton("Update");
        panel.add(this.m_updateButton);
        this.m_refreshButton = new JButton("Refresh");
        panel.add(this.m_refreshButton);
        this.m_uninstallButton = new JButton("Uninstall");
        panel.add(this.m_uninstallButton);
        this.m_startButton.setMnemonic('S');
        this.m_stopButton.setMnemonic('p');
        this.m_updateButton.setMnemonic('a');
        this.m_refreshButton.setMnemonic('R');
        this.m_uninstallButton.setMnemonic('U');
        return panel;
    }

    private void createEventListeners() {
        BundleListener bl = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                ((SimpleTableModel)BundleListPlugin.this.m_bundleTable.getModel()).update();
            }
        };
        this.m_context.addBundleListener(bl);
        this.m_installButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (BundleListPlugin.this.m_urlField.getText().length() > 0) {
                    try {
                        BundleListPlugin.this.m_context.installBundle(BundleListPlugin.this.m_urlField.getText(), null);
                    }
                    catch (BundleException ex) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(BundleListPlugin.this), ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
        this.m_startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int[] rows = BundleListPlugin.this.m_bundleTable.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    try {
                        BundleListPlugin.this.m_context.getBundles()[rows[i]].start();
                        continue;
                    }
                    catch (BundleException ex) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(BundleListPlugin.this), ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
        this.m_stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int[] rows = BundleListPlugin.this.m_bundleTable.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    try {
                        BundleListPlugin.this.m_context.getBundles()[rows[i]].stop();
                        continue;
                    }
                    catch (BundleException ex) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(BundleListPlugin.this), ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
        this.m_updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int[] rows = BundleListPlugin.this.m_bundleTable.getSelectedRows();
                for (int i = 0; i < rows.length; ++i) {
                    try {
                        BundleListPlugin.this.m_context.getBundles()[rows[i]].update();
                        continue;
                    }
                    catch (BundleException ex) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(BundleListPlugin.this), ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
        this.m_refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ServiceReference ref = BundleListPlugin.this.m_context.getServiceReference((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = BundleListPlugin.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName());
                if (ref == null) {
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(BundleListPlugin.this), "Unable to obtain PackageAdmin service.", "Error", 0);
                    return;
                }
                PackageAdmin pa = (PackageAdmin)BundleListPlugin.this.m_context.getService(ref);
                if (pa == null) {
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(BundleListPlugin.this), "Unable to obtain PackageAdmin service.", "Error", 0);
                    return;
                }
                pa.refreshPackages(null);
            }
        });
        this.m_uninstallButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int[] rows = BundleListPlugin.this.m_bundleTable.getSelectedRows();
                for (int i = rows.length - 1; i >= 0; --i) {
                    try {
                        BundleListPlugin.this.m_context.getBundles()[rows[i]].uninstall();
                        continue;
                    }
                    catch (BundleException ex) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(BundleListPlugin.this), ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
    }

    private class SimpleTableModel
    extends AbstractTableModel {
        private SimpleTableModel() {
        }

        public int getRowCount() {
            return BundleListPlugin.this.m_context.getBundles() == null ? 0 : BundleListPlugin.this.m_context.getBundles().length;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return "Id";
            }
            if (column == 1) {
                return "State";
            }
            if (column == 2) {
                return "Location";
            }
            return "";
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return class$java$lang$Long == null ? (class$java$lang$Long = BundleListPlugin.class$("java.lang.Long")) : class$java$lang$Long;
            }
            return class$java$lang$String == null ? (class$java$lang$String = BundleListPlugin.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return new Long(BundleListPlugin.this.m_context.getBundles()[row].getBundleId());
            }
            if (column == 1) {
                return this.getStateString(BundleListPlugin.this.m_context.getBundles()[row].getState());
            }
            if (column == 2) {
                String name = (String)BundleListPlugin.this.m_context.getBundles()[row].getHeaders().get("Bundle-Name");
                name = name == null ? BundleListPlugin.this.m_context.getBundles()[row].getLocation() : name;
                return name;
            }
            return null;
        }

        public void update() {
            this.fireTableDataChanged();
        }

        private String getStateString(int state) {
            switch (state) {
                case 2: {
                    return "Installed";
                }
                case 4: {
                    return "Resolved";
                }
                case 8: {
                    return "Starting";
                }
                case 32: {
                    return "Active";
                }
                case 16: {
                    return "Stopping";
                }
            }
            return "[unknown]";
        }
    }
}

