/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.ow2.jonas.ant.JOnASAntTool;

public abstract class BootstrapTask
extends Task {
    private static final String BOOTSTRAP_CLASS = "org.ow2.jonas.client.boot.Bootstrap";
    private static final String DEFAULT_SERVER_NAME = "jonas";
    private String taskName = "JOnAS";
    private File jonasRoot = null;
    private String serverName = "jonas";
    private String domainName = null;
    private File jonasBase = null;
    private String jvmOpts = null;
    private Path classpath = null;

    public void setJonasRoot(File jonasRoot) {
        this.jonasRoot = jonasRoot;
    }

    public void setJonasbase(File jonasBase) {
        this.jonasBase = jonasBase;
    }

    public void setJvmopts(String jvmOpts) {
        this.jvmOpts = jvmOpts;
    }

    public Path createClasspath() {
        return new Path(this.getProject());
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    protected Java getBootstraptask(String definedClass) {
        return this.getBootstraptask(definedClass, true);
    }

    protected Java getBootstraptask(String definedClass, boolean assignClasspath) {
        if (this.jonasRoot == null) {
            String jr = this.getProject().getProperty("jonas.root");
            this.jonasRoot = new File(jr);
            if (jr == null) {
                throw new BuildException("attribute jonasroot is necessary.");
            }
        }
        if (this.jonasBase == null) {
            this.jonasBase = this.jonasRoot;
        }
        Java bootstrapTask = (Java)this.getProject().createTask("java");
        bootstrapTask.setTaskName(this.taskName);
        bootstrapTask.setFork(true);
        bootstrapTask.setFailonerror(true);
        bootstrapTask.addSysproperty(JOnASAntTool.createVariable("jonas.name", this.serverName));
        if (this.domainName != null) {
            bootstrapTask.addSysproperty(JOnASAntTool.createVariable("domain.name", this.domainName));
        }
        bootstrapTask.addSysproperty(JOnASAntTool.createVariable("jonas.root", this.jonasRoot));
        bootstrapTask.addSysproperty(JOnASAntTool.createVariable("jonas.base", this.jonasBase));
        bootstrapTask.addSysproperty(JOnASAntTool.createVariable("java.awt.headless", "true"));
        bootstrapTask.addSysproperty(JOnASAntTool.createVariable("java.naming.factory.initial", "org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory"));
        bootstrapTask.addSysproperty(JOnASAntTool.createVariable("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB"));
        bootstrapTask.addSysproperty(JOnASAntTool.createVariable("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton"));
        bootstrapTask.addSysproperty(JOnASAntTool.createVariable("org.omg.PortableInterceptor.ORBInitializerClass.standard_init", "org.jacorb.orb.standardInterceptors.IORInterceptorInitializer"));
        File jonasLibDir = new File(this.jonasRoot, "lib");
        File jonasLibEndorsedDir = new File(jonasLibDir, "endorsed");
        bootstrapTask.addSysproperty(JOnASAntTool.createVariable("javax.rmi.CORBA.PortableRemoteObjectClass", "org.ow2.carol.rmi.multi.MultiPRODelegate"));
        bootstrapTask.addSysproperty(JOnASAntTool.createVariable("java.endorsed.dirs", jonasLibEndorsedDir));
        String jonasConfigDir = this.jonasBase + File.separator + "conf";
        File javaPolicyFile = new File(jonasConfigDir, "java.policy");
        if (javaPolicyFile.exists()) {
            bootstrapTask.addSysproperty(JOnASAntTool.createVariable("java.security.policy", javaPolicyFile));
        }
        File javaAuthLoginFile = new File(jonasConfigDir, "jaas.config");
        bootstrapTask.addSysproperty(JOnASAntTool.createVariable("java.security.auth.login.config", javaAuthLoginFile));
        bootstrapTask.createArg().setValue(definedClass);
        this.classpath = new Path(this.getProject(), jonasConfigDir);
        String bootJar = this.jonasRoot + File.separator + "lib" + File.separator + "bootstrap" + File.separator + "client-bootstrap.jar";
        this.classpath.append(new Path(this.getProject(), bootJar));
        String toolsJar = System.getProperty("java.home") + File.separator + ".." + File.separator + "lib" + File.separator + "tools.jar";
        this.classpath.append(new Path(this.getProject(), toolsJar));
        bootstrapTask.setClasspath(this.classpath);
        bootstrapTask.setClassname(BOOTSTRAP_CLASS);
        if (this.jvmOpts != null && !this.jvmOpts.equals("")) {
            bootstrapTask.createJvmarg().setLine(this.jvmOpts);
        }
        if (this.serverName != null) {
            bootstrapTask.createArg().setValue("-n");
            bootstrapTask.createArg().setValue(this.getServerName());
        }
        return bootstrapTask;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Deprecated
    public void setCatalinaHome(String catalinaHome) {
    }

    @Deprecated
    public void setJettyHome(String jettyHome) {
    }

    public File getJonasRoot() {
        return this.jonasRoot;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }
}

