/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.SAXParser;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.ow2.jonas.ant.DescriptorHandler;
import org.ow2.jonas.ant.GenericDeploymentTool;
import org.ow2.jonas.ant.JOnASAntTool;

public class JonasDeploymentTool
extends GenericDeploymentTool {
    protected static final String EJB_JAR_1_1_PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    protected static final String EJB_JAR_2_0_PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    protected static final String JONAS_EJB_JAR_2_4_PUBLIC_ID = "-//ObjectWeb//DTD JOnAS 2.4//EN";
    protected static final String JONAS_EJB_JAR_2_5_PUBLIC_ID = "-//ObjectWeb//DTD JOnAS 2.5//EN";
    protected static final String JONAS_EJB_JAR_3_0_PUBLIC_ID = "-//ObjectWeb//DTD JOnAS 3.0//EN";
    protected static final String JONAS_EJB_JAR_3_2_PUBLIC_ID = "-//ObjectWeb//DTD JOnAS 3.2//EN";
    protected static final String JONAS_EJB_JAR_3_3_PUBLIC_ID = "-//ObjectWeb//DTD JOnAS 3.3//EN";
    protected static final String JONAS_EJB_JAR_3_3_2_PUBLIC_ID = "-//ObjectWeb//DTD JOnAS 3.3.2//EN";
    protected static final String EJB_JAR_1_1_DTD = "/org/ow2/jonas/deployment/ejb/ejb-jar_1_1.dtd";
    protected static final String EJB_JAR_2_0_DTD = "/org/ow2/jonas/deployment/ejb/ejb-jar_2_0.dtd";
    protected static final String JONAS_EJB_JAR_2_4_DTD = "/org/ow2/jonas/deployment/ejb/jonas-ejb-jar_2_4.dtd";
    protected static final String JONAS_EJB_JAR_2_5_DTD = "/org/ow2/jonas/deployment/ejb/jonas-ejb-jar_2_5.dtd";
    protected static final String JONAS_EJB_JAR_3_0_DTD = "/org/ow2/jonas/deployment/ejb/jonas-ejb-jar_3_0.dtd";
    protected static final String JONAS_EJB_JAR_3_2_DTD = "/org/ow2/jonas/deployment/ejb/jonas-ejb-jar_3_2.dtd";
    protected static final String JONAS_EJB_JAR_3_3_DTD = "/org/ow2/jonas/deployment/ejb/jonas-ejb-jar_3_3.dtd";
    protected static final String JONAS_EJB_JAR_3_3_2_DTD = "/org/ow2/jonas/deployment/ejb/jonas-ejb-jar_3_3_2.dtd";
    protected static final String JONAS_DD = "jonas-ejb-jar.xml";
    protected static final String BOOTSTRAP_CLASS = "org.ow2.jonas.client.boot.Bootstrap";
    protected static final String GENIC_CLASS = "org.ow2.jonas.generators.genic.GenIC";
    private String descriptorName;
    private String jonasDescriptorName;
    private File outputdir;
    private boolean keepgenerated = false;
    private boolean nofastrmic = false;
    private boolean nocompil = false;
    private boolean invokeCmd = false;
    private boolean novalidation = false;
    private String javac;
    private String javacopts;
    private String rmicopts;
    private boolean verbose = false;
    private String additionalargs;
    private String jvmopts = null;
    private String protocols = null;
    private File jonasroot;
    private File jonasbase;
    private boolean keepgeneric = false;
    private String suffix = ".jar";
    private boolean nogenic = false;

    public void setKeepgenerated(boolean aBoolean) {
        this.keepgenerated = aBoolean;
    }

    public void setNoFastRMIC(boolean value) {
        this.nofastrmic = value;
    }

    public void setMappernames(String aString) {
        this.log("'mappernames' attribute ignored (deprecated)", 1);
    }

    public void setProtocols(String aString) {
        this.protocols = aString;
    }

    public void setClasspathref(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setAdditionalargs(String aString) {
        this.additionalargs = aString;
    }

    public void setNocompil(boolean aBoolean) {
        this.nocompil = aBoolean;
    }

    public void setInvokecmd(boolean aBoolean) {
        this.invokeCmd = aBoolean;
    }

    public void setNovalidation(boolean aBoolean) {
        this.novalidation = aBoolean;
    }

    public void setJavac(String aString) {
        this.javac = aString;
    }

    public void setJavacopts(String aString) {
        this.javacopts = aString;
    }

    public void setRmicopts(String aString) {
        this.rmicopts = aString;
    }

    public void setVerbose(boolean aBoolean) {
        this.verbose = aBoolean;
    }

    public void setJonasroot(File aFile) {
        this.jonasroot = aFile;
    }

    public void setJonasbase(File aFile) {
        this.jonasbase = aFile;
    }

    public void setKeepgeneric(boolean aBoolean) {
        this.keepgeneric = aBoolean;
    }

    public void setJarsuffix(String aString) {
        this.suffix = aString;
    }

    public void setNogenic(boolean aBoolean) {
        this.nogenic = aBoolean;
    }

    public void setJvmopts(String aString) {
        this.jvmopts = aString;
    }

    public void processDescriptor(String aDescriptorName, SAXParser saxParser) {
        this.descriptorName = aDescriptorName;
        this.log("JOnAS Deployment Tool processing for JOnAS: " + this.descriptorName, 3);
        super.processDescriptor(this.descriptorName, saxParser);
        if (this.outputdir != null) {
            this.log("Deleting temp output directory '" + this.outputdir + "'.", 3);
            JOnASAntTool.deleteAllFiles(this.outputdir);
        }
    }

    protected void writeJar(String baseName, File jarfile, Hashtable ejbFiles, String publicId, boolean includeInnerClasses) throws BuildException {
        File genericJarFile = super.getVendorOutputJarFile(baseName);
        super.writeJar(baseName, genericJarFile, ejbFiles, publicId, true);
        this.addGenICGeneratedFiles(genericJarFile, ejbFiles);
        if (this.getConfig() != null && this.getConfig().manifest != null && this.getConfig().manifest.exists()) {
            File filePathGenicManifest = (File)ejbFiles.get("META-INF/MANIFEST.MF");
            if (filePathGenicManifest != null) {
                this.mergeManifest(this.getConfig().manifest, filePathGenicManifest);
            } else {
                ejbFiles.put("META-INF/MANIFEST.MF", this.getConfig().manifest);
            }
        }
        super.writeJar(baseName, this.getVendorOutputJarFile(baseName), ejbFiles, publicId, false);
        if (!this.keepgeneric) {
            this.log("Deleting generic JAR " + genericJarFile.toString(), 3);
            genericJarFile.delete();
        }
    }

    protected void mergeManifest(File manifestUserFile, File manifestGenicFile) {
        try {
            FileInputStream userStream = new FileInputStream(manifestUserFile);
            FileInputStream genICStream = new FileInputStream(manifestGenicFile);
            Manifest userManifest = new Manifest(userStream);
            Manifest genICManifest = new Manifest(genICStream);
            ((InputStream)userStream).close();
            ((InputStream)genICStream).close();
            Attributes userMainAttributes = userManifest.getMainAttributes();
            Attributes genICMainAttributes = genICManifest.getMainAttributes();
            for (Object name : userMainAttributes.keySet()) {
                Object value = userMainAttributes.get(name);
                genICMainAttributes.put(name, value);
            }
            Map<String, Attributes> userEntries = userManifest.getEntries();
            Set<String> keys = userEntries.keySet();
            for (String key : keys) {
                Attributes attributes = userManifest.getAttributes(key);
                Attributes genICAttributes = genICManifest.getAttributes(key);
                if (genICAttributes == null) {
                    genICAttributes = new Attributes();
                    genICManifest.getEntries().put(key, genICAttributes);
                }
                Set<Object> atKeys = attributes.keySet();
                for (Object name : atKeys) {
                    Object value = attributes.get(name);
                    genICAttributes.put(name, value);
                }
            }
            FileOutputStream fos = new FileOutputStream(manifestGenicFile);
            genICManifest.write(fos);
            fos.close();
        }
        catch (IOException e) {
            this.log("Unable to update Manifest with user manifest :" + e.getMessage(), 1);
        }
    }

    protected void addVendorFiles(Hashtable ejbFiles, String ddPrefix) {
        this.jonasDescriptorName = this.getJonasDescriptorName();
        File jonasDD = new File(this.getConfig().descriptorDir, this.jonasDescriptorName);
        if (jonasDD.exists()) {
            ejbFiles.put("META-INF/jonas-ejb-jar.xml", jonasDD);
        } else {
            this.log("Unable to locate the JOnAS deployment descriptor. It was expected to be in: " + jonasDD.getPath() + ".", 1);
        }
    }

    protected File getVendorOutputJarFile(String baseName) {
        return new File(this.getDestDir(), baseName + this.suffix);
    }

    private String getJonasDescriptorName() {
        String fileName;
        String path;
        boolean jonasConvention = false;
        int startOfFileName = this.descriptorName.lastIndexOf(File.separatorChar);
        if (startOfFileName != -1) {
            path = this.descriptorName.substring(0, startOfFileName + 1);
            fileName = this.descriptorName.substring(startOfFileName + 1);
        } else {
            path = "";
            fileName = this.descriptorName;
        }
        if (fileName.startsWith("ejb-jar.xml")) {
            return path + JONAS_DD;
        }
        int endOfBaseName = this.descriptorName.indexOf(this.getConfig().baseNameTerminator, startOfFileName);
        if (endOfBaseName < 0) {
            endOfBaseName = this.descriptorName.lastIndexOf(46) - 1;
            if (endOfBaseName < 0) {
                endOfBaseName = this.descriptorName.length() - 1;
            }
            jonasConvention = true;
        }
        String baseName = this.descriptorName.substring(startOfFileName + 1, endOfBaseName + 1);
        String remainder = this.descriptorName.substring(endOfBaseName + 1);
        String jonasDescriptorName = jonasConvention ? path + "jonas-" + baseName + ".xml" : path + baseName + "jonas-" + remainder;
        this.log("Standard EJB descriptor name: " + this.descriptorName, 3);
        this.log("JOnAS-specific descriptor name: " + jonasDescriptorName, 3);
        return jonasDescriptorName;
    }

    protected String getJarBaseName(String descriptorFileName) {
        String aCanonicalDescriptor;
        int lastSeparatorIndex;
        int endOfBaseName;
        String baseName = null;
        if (this.getConfig().namingScheme.getValue().equals("descriptor") && descriptorFileName.indexOf(this.getConfig().baseNameTerminator) == -1 && (endOfBaseName = (lastSeparatorIndex = (aCanonicalDescriptor = descriptorFileName.replace('\\', '/')).lastIndexOf(47)) != -1 ? descriptorFileName.indexOf(".xml", lastSeparatorIndex) : descriptorFileName.indexOf(".xml")) != -1) {
            baseName = descriptorFileName.substring(0, endOfBaseName);
        }
        if (baseName == null) {
            baseName = super.getJarBaseName(descriptorFileName);
        }
        this.log("JAR base name: " + baseName, 3);
        return baseName;
    }

    protected void registerKnownDTDs(DescriptorHandler handler) {
        handler.registerDTD(EJB_JAR_1_1_PUBLIC_ID, EJB_JAR_1_1_DTD);
        handler.registerDTD(EJB_JAR_2_0_PUBLIC_ID, EJB_JAR_2_0_DTD);
        handler.registerDTD(JONAS_EJB_JAR_2_4_PUBLIC_ID, JONAS_EJB_JAR_2_4_DTD);
        handler.registerDTD(JONAS_EJB_JAR_2_5_PUBLIC_ID, JONAS_EJB_JAR_2_5_DTD);
        handler.registerDTD(JONAS_EJB_JAR_3_0_PUBLIC_ID, JONAS_EJB_JAR_3_0_DTD);
        handler.registerDTD(JONAS_EJB_JAR_3_2_PUBLIC_ID, JONAS_EJB_JAR_3_2_DTD);
        handler.registerDTD(JONAS_EJB_JAR_3_3_PUBLIC_ID, JONAS_EJB_JAR_3_3_DTD);
        handler.registerDTD(JONAS_EJB_JAR_3_3_2_PUBLIC_ID, JONAS_EJB_JAR_3_3_2_DTD);
    }

    private void addGenICGeneratedFiles(File genericJarFile, Hashtable ejbFiles) {
        Java genicTask = null;
        if (this.nogenic) {
            return;
        }
        genicTask = (Java)this.getTask().getProject().createTask("java");
        genicTask.setTaskName("genic");
        genicTask.setFork(true);
        genicTask.createJvmarg().setValue("-Djonas.root=" + this.jonasroot);
        genicTask.createJvmarg().setValue("-Djonas.base=" + this.jonasbase);
        File endorsedDir = new File(new File(this.jonasroot, "lib"), "endorsed");
        genicTask.createJvmarg().setValue("-Djava.endorsed.dirs=" + endorsedDir);
        String jonasConfigDir = this.jonasroot + File.separator + "conf";
        File javaPolicyFile = new File(jonasConfigDir, "java.policy");
        if (javaPolicyFile.exists()) {
            genicTask.createJvmarg().setValue("-Djava.security.policy=" + javaPolicyFile.toString());
        }
        genicTask.createArg().setValue(GENIC_CLASS);
        try {
            this.outputdir = this.createTempDir();
        }
        catch (IOException aIOException) {
            throw new BuildException("Cannot create temp dir", (Throwable)aIOException);
        }
        this.log("Using temporary output directory: " + this.outputdir, 3);
        genicTask.createArg().setValue("-d");
        genicTask.createArg().setFile(this.outputdir);
        Path classpath = this.getCombinedClasspath();
        if (classpath == null) {
            classpath = new Path(this.getTask().getProject());
        }
        String bootJar = this.jonasroot + File.separator + "lib" + File.separator + "bootstrap" + File.separator + "client-bootstrap.jar";
        String clientJar = this.jonasroot + File.separator + "lib" + File.separator + "client.jar";
        Path bootstrap = new Path(this.getTask().getProject(), bootJar);
        Path clientPath = new Path(this.getTask().getProject(), clientJar);
        bootstrap.append(clientPath);
        classpath.append(new Path(classpath.getProject(), this.outputdir.toString()));
        this.log("Using classpath: " + bootstrap.toString(), 3);
        genicTask.setClasspath(bootstrap);
        if (!this.checkBootstrapClassName(bootstrap)) {
            this.log("Cannot find bootstrap class in classpath.", 0);
            throw new BuildException("Bootstrap class not found, please check the classpath.");
        }
        genicTask.setClassname(BOOTSTRAP_CLASS);
        genicTask.createArg().setValue("-classpath");
        genicTask.createArg().setPath(classpath);
        if (this.keepgenerated) {
            genicTask.createArg().setValue("-keepgenerated");
        }
        if (this.nofastrmic) {
            genicTask.createArg().setValue("-nofastrmic");
        }
        if (this.nocompil) {
            genicTask.createArg().setValue("-nocompil");
        }
        if (this.invokeCmd) {
            genicTask.createArg().setValue("-invokecmd");
        }
        if (this.novalidation) {
            genicTask.createArg().setValue("-novalidation");
        }
        if (this.javac != null) {
            genicTask.createArg().setValue("-javac");
            genicTask.createArg().setLine(this.javac);
        }
        if (this.javacopts != null && !this.javacopts.equals("")) {
            genicTask.createArg().setValue("-javacopts");
            genicTask.createArg().setValue(this.javacopts);
        }
        if (this.rmicopts != null && !this.rmicopts.equals("")) {
            genicTask.createArg().setValue("-rmicopts");
            genicTask.createArg().setValue(this.rmicopts);
        }
        if (this.verbose) {
            genicTask.createArg().setValue("-verbose");
        }
        if (this.additionalargs != null) {
            genicTask.createArg().setLine(this.additionalargs);
        }
        if (this.protocols != null) {
            genicTask.createArg().setValue("-protocols");
            genicTask.createArg().setValue(this.protocols);
        }
        genicTask.createArg().setValue("-noaddinjar");
        if (this.jvmopts != null && !this.jvmopts.equals("")) {
            genicTask.createJvmarg().setLine(this.jvmopts);
        }
        genicTask.createArg().setValue(genericJarFile.getPath());
        this.log("Calling  GenIC task for " + this.getConfig().descriptorDir + File.separator + this.descriptorName + ".", 3);
        if (genicTask.executeJava() != 0) {
            if (!this.keepgeneric) {
                this.log("Deleting generic JAR " + genericJarFile.toString(), 3);
                genericJarFile.delete();
            }
            throw new BuildException("GenIC reported an error.");
        }
        this.addAllFiles(this.outputdir, "", ejbFiles);
    }

    private boolean checkBootstrapClassName(Path classpath) {
        this.log("Looking for bootstrap class in classpath: " + classpath.toString(), 3);
        AntClassLoader cl = new AntClassLoader(classpath.getProject(), classpath);
        try {
            cl.loadClass(BOOTSTRAP_CLASS);
            this.log("Found Bootstrap class 'org.ow2.jonas.client.boot.Bootstrap' in classpath.", 3);
        }
        catch (ClassNotFoundException cnf1) {
            this.log("Bootstrap class 'org.ow2.jonas.client.boot.Bootstrap' not found in classpath.", 3);
            return false;
        }
        return true;
    }

    protected void checkConfiguration(String descriptorFileName, SAXParser saxParser) throws BuildException {
        if (this.jonasroot == null) {
            throw new BuildException("The jonasroot attribute is not set.");
        }
        if (!this.jonasroot.isDirectory()) {
            throw new BuildException("The jonasroot attribute '" + this.jonasroot + "' is not a valid directory.");
        }
        if (this.jonasbase == null) {
            this.jonasbase = this.jonasroot;
        }
        if (this.additionalargs != null && this.additionalargs.equals("")) {
            throw new BuildException("Empty additionalargs attribute.");
        }
        if (this.javac != null && this.javac.equals("")) {
            throw new BuildException("Empty javac attribute.");
        }
    }

    private File createTempDir() throws IOException {
        File tmpDir = File.createTempFile("genic", null, null);
        tmpDir.delete();
        if (!tmpDir.mkdir()) {
            throw new IOException("Cannot create the temporary directory '" + tmpDir + "'.");
        }
        return tmpDir;
    }

    private void addAllFiles(File file, String rootDir, Hashtable hashtable) {
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String newRootDir = rootDir.length() > 0 ? rootDir + File.separator + files[i].getName() : files[i].getName();
                this.addAllFiles(files[i], newRootDir, hashtable);
            }
        } else {
            hashtable.put(rootDir.replace(File.separatorChar, '/'), file);
        }
    }
}

