/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.jonasbase;

import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Echo;
import org.ow2.jonas.ant.jonasbase.BaseTaskItf;
import org.ow2.jonas.ant.jonasbase.JReplace;
import org.ow2.jonas.ant.jonasbase.Tasks;

public class Carol
extends Tasks {
    private static final String INFO = "[Carol] ";
    private static final String PROTOCOLS_PROPERTY = "carol.protocols";
    private static final String DEFAULT_PROTOCOLS = "jrmp";
    private static final String DEFAULT_HOST = "localhost";
    private static final String PROTOCOL_HEADER = "://";
    private static final String DEFAULT_JRMP_PORT = "1099";
    private static final String DEFAULT_IIOP_PORT = "2001";
    private static final String DEFAULT_IRMI_PORT = "1098";
    private static final String OPTIMIZATION_PROPERTY = "carol.jvm.rmi.local.call=";
    private static final String OPTIMIZATION_OFF = "carol.jvm.rmi.local.call=false";
    private static final String OPTIMIZATION_ON = "carol.jvm.rmi.local.call=true";
    private static final String LOCALREGISTRY_PROPERTY = "carol.jvm.rmi.local.registry=";
    private static final String LOCALREGISTRY_OFF = "carol.jvm.rmi.local.registry=false";
    private static final String LOCALREGISTRY_ON = "carol.jvm.rmi.local.registry=true";
    public static final String CMI_STARTED = "carol.start.cmi=";
    public static final String CMI_STARTED_ON = "carol.start.cmi=true";
    public static final String CMI_STARTED_OFF = "carol.start.cmi=false";
    public static final String SEQ_PROTOCOLS_TO_PROVIDER_URLS = "cmi.server.provider.urls=";

    private void setURL(String protocolName, String hostName, String portNumber, String protocolUrl, String tokenToReplace) {
        String url = null;
        String token = protocolName + PROTOCOL_HEADER + DEFAULT_HOST + ":" + tokenToReplace;
        url = protocolUrl != null ? protocolUrl : protocolName + PROTOCOL_HEADER + hostName + ":" + portNumber;
        JReplace propertyReplace = new JReplace();
        propertyReplace.setLogInfo("[Carol] Setting URL for protocol '" + protocolName + "' to : " + url);
        propertyReplace.setConfigurationFile("carol.properties");
        propertyReplace.setToken(token);
        propertyReplace.setValue(url);
        this.addTask((Task)propertyReplace);
    }

    public void setJrmpPort(String portNumber) {
        this.setURL("rmi", DEFAULT_HOST, portNumber, null, DEFAULT_JRMP_PORT);
    }

    public void setJeremiePort(String portNumber) {
        this.addTask(new MyEcho());
    }

    public void setIiopPort(String portNumber) {
        this.setURL("iiop", DEFAULT_HOST, portNumber, null, DEFAULT_IIOP_PORT);
    }

    public void setIrmiPort(String portNumber) {
        this.setURL("rmi", DEFAULT_HOST, portNumber, null, DEFAULT_IRMI_PORT);
    }

    public void setDefaultPort(String portNumber) {
        this.setJrmpPort(portNumber);
        this.setIiopPort(portNumber);
        this.setIrmiPort(portNumber);
    }

    public void setProtocols(String protocols) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("carol.properties");
        propertyReplace.setToken("carol.protocols=jrmp");
        propertyReplace.setValue("carol.protocols=" + protocols);
        propertyReplace.setLogInfo("[Carol] Setting protocols to : " + protocols);
        this.addTask((Task)propertyReplace);
    }

    public void setJrmpOptimization(boolean enabled) {
        if (!enabled) {
            return;
        }
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("carol.properties");
        propertyReplace.setToken(OPTIMIZATION_OFF);
        propertyReplace.setValue(OPTIMIZATION_ON);
        propertyReplace.setLogInfo("[Carol] Enable JRMP optimization: " + enabled);
        this.addTask((Task)propertyReplace);
    }

    public void setLocalRegistry(boolean enabled) {
        if (!enabled) {
            return;
        }
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("carol.properties");
        propertyReplace.setToken(LOCALREGISTRY_OFF);
        propertyReplace.setValue(LOCALREGISTRY_ON);
        propertyReplace.setLogInfo("[Carol] Enable local registry  setting: " + enabled);
        this.addTask((Task)propertyReplace);
    }

    public void setCmiStarted(boolean enabled) {
        if (!enabled) {
            return;
        }
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("carol.properties");
        propertyReplace.setToken(CMI_STARTED_OFF);
        propertyReplace.setValue(CMI_STARTED_ON);
        propertyReplace.setLogInfo("[Carol] Enable start cmi  setting: " + enabled);
        this.addTask((Task)propertyReplace);
    }

    public void setClusterViewProviderUrls(String seqProtocol2ProviderURLs) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("carol.properties");
        propertyReplace.setToken(SEQ_PROTOCOLS_TO_PROVIDER_URLS);
        propertyReplace.setValue(SEQ_PROTOCOLS_TO_PROVIDER_URLS + seqProtocol2ProviderURLs);
        propertyReplace.setLogInfo("[Carol] Setting sequence of protocols and provider urls to : " + seqProtocol2ProviderURLs);
        this.addTask((Task)propertyReplace);
    }

    public class MyEcho
    extends Task
    implements BaseTaskItf {
        private Echo echo = new Echo();

        public void setTaskName(String arg0) {
            super.setTaskName(arg0);
            this.echo.setTaskName(arg0);
        }

        public void setProject(Project arg0) {
            super.setProject(arg0);
            this.echo.setProject(arg0);
        }

        public void execute() {
            this.echo.setMessage("[Carol] Attribute 'jeremie' is deprecated. This protocol is no more supported by JOnAS.");
            this.echo.execute();
        }

        public String getLogInfo() {
            return null;
        }

        public void setConfigurationFile(String configurationFile) {
        }

        public void setDestDir(File destDir) {
        }

        public void setJonasRoot(File jonasRoot) {
        }

        public void setLogInfo(String logInfo) {
        }
    }
}

