/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.configuration;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.ServerConfiguration;
import org.ow2.carol.util.configuration.ServerConfigurationImplMBean;
import org.ow2.carol.util.configuration.TraceCarol;

public class ServerConfigurationImpl
implements ServerConfiguration,
ServerConfigurationImplMBean {
    private static Log logger = LogFactory.getLog(ServerConfigurationImpl.class);
    private final Properties properties;
    private final boolean startNS;
    private final boolean startJNDI;
    private final boolean startRMI;
    private volatile boolean startCMI;
    private volatile String cmiInitialContextFactory = null;
    private final String domainName;
    private final String serverName;
    private String objectName;
    private final String agentId;
    private final boolean server;
    private volatile boolean multiEnvironment;

    protected ServerConfigurationImpl(Properties properties, String domainName, String serverName, String agentId) throws ConfigurationException {
        String key;
        this.properties = properties;
        this.domainName = domainName;
        this.serverName = serverName;
        this.agentId = agentId;
        if (properties == null) {
            throw new ConfigurationException("Cannot build a server configuration without properties");
        }
        this.startNS = this.getBooleanValue("carol.start.ns");
        this.startRMI = this.getBooleanValue("carol.start.rmi");
        this.startJNDI = this.getBooleanValue("carol.start.jndi");
        this.server = System.getProperty("carol.server.mode", "false").equalsIgnoreCase("true");
        logger.debug((Object)System.getProperties());
        this.startCMI = System.getProperty("carol.start.cmi", Boolean.toString(this.getBooleanValue("carol.start.cmi"))).equalsIgnoreCase("true");
        Properties jvmProperties = new Properties();
        if (this.startRMI) {
            jvmProperties.setProperty("javax.rmi.CORBA.PortableRemoteObjectClass", "org.ow2.carol.rmi.multi.MultiPRODelegate");
        }
        if (this.startJNDI) {
            jvmProperties.setProperty("java.naming.factory.initial", "org.ow2.carol.jndi.spi.MultiOrbInitialContextFactory");
        }
        if (this.startCMI) {
            this.initCMI();
        }
        String protocols = properties.getProperty("carol.protocols");
        boolean isMultiProtocols = false;
        if (protocols != null) {
            isMultiProtocols = protocols.split(",").length > 1;
        }
        this.multiEnvironment = this.getBooleanValue("carol.multi.env");
        String jndiPrefix = "carol.jndi";
        String multiJvmPrefix = "multi.carol.jvm";
        String singleJvmPrefix = "carol.jvm";
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String newKey;
            key = (String)e.nextElement();
            if (key.startsWith(jndiPrefix)) {
                jvmProperties.setProperty(key.substring(jndiPrefix.length() + 1), properties.getProperty(key));
            }
            if (key.startsWith(multiJvmPrefix) && isMultiProtocols) {
                newKey = key.substring(multiJvmPrefix.length() + 1);
                jvmProperties.setProperty(newKey, "");
            }
            if (!key.startsWith(singleJvmPrefix)) continue;
            newKey = key.substring(singleJvmPrefix.length() + 1);
            jvmProperties.setProperty(newKey, properties.getProperty(key));
        }
        e = jvmProperties.propertyNames();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            String value = jvmProperties.getProperty(key);
            System.setProperty(key, value);
            if (!TraceCarol.isDebugCarol()) continue;
            TraceCarol.debugCarol("Set the JVM property '" + key + "' with the value '" + value + "'.");
        }
    }

    protected void initCMI() throws ConfigurationException {
        String cmiPropertyName;
        String setterClass;
        this.cmiInitialContextFactory = this.properties.getProperty("cmi.context.factory");
        if (this.server && (setterClass = this.properties.getProperty(cmiPropertyName = "carol.cmi.setter.class")) != null) {
            String setterMethodProperties = this.properties.getProperty("carol.cmi.setter.methodProperties");
            String setterMethodMBean = this.properties.getProperty("carol.cmi.setter.methodMBean");
            try {
                Class<?> clazz;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(setterClass);
                }
                catch (ClassNotFoundException cnfe) {
                    clazz = this.getClass().getClassLoader().loadClass(setterClass);
                }
                Method mMBean = clazz.getMethod(setterMethodMBean, String.class, String.class, String.class);
                mMBean.invoke(null, this.domainName, this.serverName, this.agentId);
                Method mProperties = clazz.getMethod(setterMethodProperties, Properties.class);
                mProperties.invoke(null, this.properties);
            }
            catch (Exception ex) {
                TraceCarol.error("Cannot set the CMI configuration.", ex);
                throw new ConfigurationException("Cannot set the CMI configuration.", ex);
            }
        }
    }

    protected boolean getBooleanValue(String key) throws ConfigurationException {
        String s = this.properties.getProperty(key);
        if (s == null) {
            throw new ConfigurationException("Property '" + key + "' was not found in the properties object of the protocol, properties are :'" + this.properties + "'");
        }
        return Boolean.parseBoolean(s.trim());
    }

    public boolean isStartingJNDI() {
        return this.startJNDI;
    }

    public boolean isStartingNS() {
        return this.startNS;
    }

    public boolean isStartingRMI() {
        return this.startRMI;
    }

    public boolean isStartCMI() {
        return this.startCMI;
    }

    public String getCmiInitialContextFactory() {
        return this.cmiInitialContextFactory;
    }

    public synchronized void setStartCMI(boolean startCMI) throws Exception {
        this.startCMI = startCMI;
        if (startCMI && this.cmiInitialContextFactory == null) {
            this.initCMI();
        }
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isServer() {
        return this.server;
    }

    public boolean isMultiEnvironment() {
        return this.multiEnvironment;
    }

    public void setMultiEnvironment(boolean multiEnvironment) {
        this.multiEnvironment = multiEnvironment;
    }
}

