/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.providedservice;

import java.util.Iterator;
import org.apache.felix.ipojo.Handler;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.handlers.providedservice.ProvidedServiceDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;

public class ProvidedServiceHandlerDescription
extends HandlerDescription {
    private ProvidedServiceDescription[] m_providedServices = new ProvidedServiceDescription[0];

    public ProvidedServiceHandlerDescription(Handler h) {
        super(h);
    }

    public ProvidedServiceDescription[] getProvidedServices() {
        return this.m_providedServices;
    }

    public void addProvidedService(ProvidedServiceDescription pds) {
        for (int i = 0; i < this.m_providedServices.length; ++i) {
            if (this.m_providedServices[i] != pds) continue;
            return;
        }
        ProvidedServiceDescription[] newPSD = new ProvidedServiceDescription[this.m_providedServices.length + 1];
        System.arraycopy(this.m_providedServices, 0, newPSD, 0, this.m_providedServices.length);
        newPSD[this.m_providedServices.length] = pds;
        this.m_providedServices = newPSD;
    }

    public Element getHandlerInfo() {
        Element services = super.getHandlerInfo();
        for (int i = 0; i < this.m_providedServices.length; ++i) {
            Element service = new Element("provides", "");
            String spec = "[";
            for (int j = 0; j < this.m_providedServices[i].getServiceSpecification().length; ++j) {
                spec = j == 0 ? spec + this.m_providedServices[i].getServiceSpecification()[j] : spec + ", " + this.m_providedServices[i].getServiceSpecification()[j];
            }
            spec = spec + "]";
            service.addAttribute(new Attribute("specifications", spec));
            if (this.m_providedServices[i].getState() == 1) {
                service.addAttribute(new Attribute("state", "registered"));
                service.addAttribute(new Attribute("service.id", this.m_providedServices[i].getServiceReference().getProperty("service.id").toString()));
            } else {
                service.addAttribute(new Attribute("state", "unregistered"));
            }
            Iterator<Object> it = this.m_providedServices[i].getProperties().keySet().iterator();
            while (it.hasNext()) {
                Element prop = new Element("property", "");
                String k = (String)it.next();
                prop.addAttribute(new Attribute("name", k));
                prop.addAttribute(new Attribute("value", this.m_providedServices[i].getProperties().getProperty(k).toString()));
                service.addElement(prop);
            }
            services.addElement(service);
        }
        return services;
    }
}

