/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb.easybeans;

import java.security.Principal;
import java.security.acl.Group;
import javax.security.auth.Subject;
import org.ow2.easybeans.security.api.EZBSecurityContext;
import org.ow2.easybeans.security.struct.JPrincipal;
import org.ow2.jonas.lib.security.context.SecurityContext;

public class JOnASSecurityContextWrapper
implements EZBSecurityContext {
    private SecurityContext jonasSecurityContext = null;

    public JOnASSecurityContextWrapper(SecurityContext jonasSecurityContext) {
        this.jonasSecurityContext = jonasSecurityContext;
    }

    public Principal getCallerPrincipal(boolean runAsBean) {
        return this.jonasSecurityContext.getCallerPrincipal(runAsBean);
    }

    public Principal[] getCallerRoles(boolean runAsBean) {
        String[] roles = this.jonasSecurityContext.getCallerPrincipalRoles(runAsBean);
        if (roles == null) {
            throw new IllegalStateException("No roles found on the JOnAS security context");
        }
        Principal[] principals = new Principal[roles.length];
        int i = 0;
        for (String role : roles) {
            principals[i++] = new JPrincipal(role);
        }
        return principals;
    }

    public Subject enterRunAs(Subject runAsSubject) {
        String principalName = null;
        for (Principal principal : runAsSubject.getPrincipals(Principal.class)) {
            if (principal instanceof Group) continue;
            principalName = principal.getName();
            break;
        }
        String role = null;
        for (Principal principal : runAsSubject.getPrincipals(Principal.class)) {
            if (!(principal instanceof Group)) continue;
            role = ((Principal)((Group)principal).members().nextElement()).getName();
        }
        this.jonasSecurityContext.pushRunAs(role, principalName, new String[]{role});
        return null;
    }

    public void endsRunAs(Subject oldSubject) {
        this.jonasSecurityContext.popRunAs();
    }
}

