/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

final class HTTPMethodSpec {
    private static final String[] HTTP_METHODS = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE"};
    private static final int[] HTTP_MASKS = new int[]{1, 2, 4, 8, 16, 32, 64};
    static final int NA = 0;
    static final int INTEGRAL = 1;
    static final int CONFIDENTIAL = 2;
    static final int NONE = 3;
    private final int mask;
    private final int transport;
    private String actions;

    public HTTPMethodSpec(String[] HTTPMethods) {
        this(HTTPMethods, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HTTPMethodSpec(String name, boolean parseTransportType) {
        if (parseTransportType) {
            if (name == null || name.length() == 0) {
                this.transport = 3;
            } else {
                String[] tokens = name.split(":", 2);
                if (tokens.length == 2) {
                    if (tokens[1].equals("NONE")) {
                        this.transport = 3;
                    } else if (tokens[1].equals("INTEGRAL")) {
                        this.transport = 1;
                    } else {
                        if (!tokens[1].equals("CONFIDENTIAL")) throw new IllegalArgumentException("Invalid transportType: " + tokens[1]);
                        this.transport = 2;
                    }
                } else {
                    this.transport = 3;
                }
                name = tokens[0];
            }
        } else {
            this.transport = 0;
        }
        if (name == null || name.length() == 0) {
            this.mask = 127;
            return;
        } else {
            String[] methods = name.split(",", -1);
            int tmpMask = 0;
            for (int i = 0; i < methods.length; ++i) {
                boolean found = false;
                for (int j = 0; j < HTTP_METHODS.length; ++j) {
                    if (!methods[i].equals(HTTP_METHODS[j])) continue;
                    tmpMask |= HTTP_MASKS[j];
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("Invalid HTTPMethodSpec");
            }
            this.mask = tmpMask;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HTTPMethodSpec(String[] HTTPMethods, String transport) {
        boolean parseTransportType;
        boolean bl = parseTransportType = transport != null;
        if (HTTPMethods == null || HTTPMethods.length == 0) {
            this.mask = 127;
        } else {
            int tmpMask = 0;
            for (int i = 0; i < HTTPMethods.length; ++i) {
                for (int j = 0; j < HTTP_METHODS.length; ++j) {
                    if (!HTTPMethods[i].equals(HTTP_METHODS[j])) continue;
                    tmpMask |= HTTP_MASKS[j];
                    break;
                }
                if (tmpMask != 0) continue;
                throw new IllegalArgumentException("Invalid HTTPMethodSpec");
            }
            this.mask = tmpMask;
        }
        if (parseTransportType) {
            if (transport.length() == 0 || transport.equals("NONE")) {
                this.transport = 3;
                return;
            } else if (transport.equals("INTEGRAL")) {
                this.transport = 1;
                return;
            } else {
                if (!transport.equals("CONFIDENTIAL")) throw new IllegalArgumentException("Invalid transport");
                this.transport = 2;
            }
            return;
        } else {
            this.transport = 0;
        }
    }

    public HTTPMethodSpec(String singleMethod, int transport) {
        int tmpMask = 0;
        for (int j = 0; j < HTTP_METHODS.length; ++j) {
            if (!HTTP_METHODS[j].equals(singleMethod)) continue;
            tmpMask = HTTP_MASKS[j];
            break;
        }
        if (tmpMask == 0) {
            throw new IllegalArgumentException("Invalid HTTPMethodSpec");
        }
        this.mask = tmpMask;
        this.transport = transport;
    }

    public boolean equals(HTTPMethodSpec o) {
        return this.mask == o.mask && this.transport == o.transport;
    }

    public String getActions() {
        if (this.actions == null) {
            boolean first = true;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < HTTP_MASKS.length; ++i) {
                if ((this.mask & HTTP_MASKS[i]) <= 0) continue;
                if (first) {
                    first = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(HTTP_METHODS[i]);
            }
            if (this.transport == 1) {
                buffer.append(":INTEGRAL");
            } else if (this.transport == 2) {
                buffer.append(":CONFIDENTIAL");
            }
            this.actions = buffer.toString();
        }
        return this.actions;
    }

    public int hashCode() {
        return this.mask ^ this.transport;
    }

    public boolean implies(HTTPMethodSpec p) {
        return (this.mask & p.mask) == p.mask && (this.transport & p.transport) == p.transport;
    }
}

