/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JNDIUtils {
    private JNDIUtils() {
    }

    public static byte[] getBytesFromObject(Object obj) {
        return JNDIUtils.getBytesFromObject(obj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromObject(Object obj, Logger logger) {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        byte[] bytes = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            bytes = baos.toByteArray();
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            block13: {
                try {
                    oos.close();
                    baos.close();
                }
                catch (Exception e) {
                    if (logger == null) break block13;
                    logger.log(BasicLevel.DEBUG, (Object)("Cannot close output streams : '" + e.getMessage() + "'"));
                }
            }
        }
        return bytes;
    }

    public static Object getObjectFromBytes(byte[] bytes) {
        return JNDIUtils.getObjectFromBytes(bytes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObjectFromBytes(byte[] bytes, Logger logger) {
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        Object obj = null;
        if (bytes == null) {
            return null;
        }
        bis = new ByteArrayInputStream(bytes);
        try {
            ois = new ObjectInputStream(bis);
            obj = ois.readObject();
        }
        catch (ClassNotFoundException cfe) {
            if (logger != null) {
                logger.log(BasicLevel.DEBUG, (Object)("Cannot get object from bytes : " + cfe.getMessage()));
            }
        }
        catch (OptionalDataException ode) {
            if (logger != null) {
                logger.log(BasicLevel.DEBUG, (Object)("Cannot get object from bytes : " + ode.getMessage()));
            }
        }
        catch (IOException ioe) {
            if (logger != null) {
                logger.log(BasicLevel.DEBUG, (Object)("Cannot get object from bytes : " + ioe.getMessage()));
            }
        }
        finally {
            block24: {
                try {
                    bis.close();
                    ois.close();
                }
                catch (Exception e) {
                    if (logger == null) break block24;
                    logger.log(BasicLevel.DEBUG, (Object)("Cannot close input stream : " + e.getMessage()));
                }
            }
        }
        return obj;
    }
}

