/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.work;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.work.CleanerException;
import org.ow2.jonas.lib.work.LogEntry;

public abstract class AbsCleanTask {
    private static Logger logger = Log.getLogger("org.ow2.jonas.work");

    protected AbsCleanTask() {
    }

    protected static Logger getLogger() {
        return logger;
    }

    protected abstract boolean isValidLogEntry(LogEntry var1) throws CleanerException;

    protected abstract void removeLogEntry(LogEntry var1) throws CleanerException;

    protected abstract Vector getLogEntries();

    protected abstract boolean isDeployLogEntry(LogEntry var1) throws CleanerException;

    public void execute() throws CleanerException {
        if (AbsCleanTask.getLogger().isLoggable(BasicLevel.DEBUG)) {
            AbsCleanTask.getLogger().log(BasicLevel.DEBUG, (Object)"execute : called");
        }
        Vector logEntries = this.getLogEntries();
        LogEntry logEntry = null;
        Enumeration e = logEntries.elements();
        while (e.hasMoreElements()) {
            logEntry = (LogEntry)e.nextElement();
            if (AbsCleanTask.getLogger().isLoggable(BasicLevel.DEBUG)) {
                AbsCleanTask.getLogger().log(BasicLevel.DEBUG, (Object)("LogEntry <" + logEntry.getOriginal().getName() + "," + logEntry.getCopy().getName() + ">"));
            }
            if (this.isDeployLogEntry(logEntry)) {
                if (!AbsCleanTask.getLogger().isLoggable(BasicLevel.DEBUG)) continue;
                AbsCleanTask.getLogger().log(BasicLevel.DEBUG, (Object)"LogEntry currently deployed - > do nothing");
                continue;
            }
            if (this.isValidLogEntry(logEntry)) continue;
            this.removeLogEntry(logEntry);
            e = logEntries.elements();
        }
    }

    protected void removeRecursiveDirectory(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] childFiles = file.listFiles();
            for (int i = 0; i < childFiles.length; ++i) {
                this.removeRecursiveDirectory(childFiles[i]);
            }
        }
        file.delete();
    }
}

