#!/bin/sh
# ---------------------------------------------------------------------------
# JOnAS: Java(TM) Open Application Server
# Copyright (C) 2005-2008 Bull S.A.S.
# Contact: jonas-team@ow2.org
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
# USA
#
# Initial developer(s): Florent Benoit
# Contributor(s): Benoit Pelletier
# ---------------------------------------------------------------------------
# $Id: newjb.sh 12730 2008-01-28 13:48:29Z sauthieg $
# ---------------------------------------------------------------------------

# -----------------------------------------------------------------------
# Compute JONAS_ROOT in case it has not been set.
# -----------------------------------------------------------------------
if [ ! -d $JONAS_ROOT/deploy ]
then
  zdir=$(pushd $(dirname $0)>/dev/null; pwd; popd>/dev/null)
  zfqn=$zdir/$(basename "$0")
  JONAS_ROOT=$(dirname $(dirname $zdir))
  export JONAS_ROOT
fi

# -----------------------------------------------------------------------
# Debugging properties
#ANT_OPTS="-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,address=4143,suspend=y"
#export ANT_OPT
# -----------------------------------------------------------------------

ant -file $JONAS_ROOT/build-jb.xml
