/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.BundleRevision;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.moduleloader.DirectoryContent;
import org.apache.felix.moduleloader.IContent;
import org.apache.felix.moduleloader.JarContent;

class DirectoryRevision
extends BundleRevision {
    private static final transient String BUNDLE_JAR_FILE = "bundle.jar";
    private File m_refDir = null;
    private Map m_header = null;

    public DirectoryRevision(Logger logger, File revisionRootDir, String location) throws Exception {
        super(logger, revisionRootDir, location);
        this.m_refDir = new File(location.substring(location.indexOf("file:") + "file:".length()));
        if (BundleCache.getSecureAction().fileExists(this.getRevisionRootDir())) {
            return;
        }
        if (!BundleCache.getSecureAction().mkdir(this.getRevisionRootDir())) {
            this.getLogger().log(1, this.getClass().getName() + ": Unable to create revision directory.");
            throw new IOException("Unable to create archive directory.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map getManifestHeader() throws Exception {
        if (this.m_header != null) {
            return this.m_header;
        }
        InputStream is = null;
        try {
            is = BundleCache.getSecureAction().getFileInputStream(new File(this.m_refDir, "META-INF/MANIFEST.MF"));
            if (is == null) {
                throw new IOException("No manifest file found.");
            }
            Manifest mf = new Manifest(is);
            Map map = this.m_header = new StringMap(mf.getMainAttributes(), false);
            return map;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public IContent getContent() throws Exception {
        return new DirectoryContent(this.m_refDir);
    }

    public synchronized IContent[] getContentPath() throws Exception {
        Map map = this.getManifestHeader();
        String classPath = map == null ? null : (String)map.get("Bundle-ClassPath");
        String[] classPathStrings = ManifestParser.parseDelimitedString(classPath, ",");
        if (classPathStrings == null) {
            classPathStrings = new String[]{};
        }
        DirectoryContent self = new DirectoryContent(this.m_refDir);
        ArrayList<IContent> contentList = new ArrayList<IContent>();
        for (int i = 0; i < classPathStrings.length; ++i) {
            String string = classPathStrings[i] = classPathStrings[i].startsWith("/") ? classPathStrings[i].substring(1) : classPathStrings[i];
            if (classPathStrings[i].equals(".")) {
                contentList.add(self);
                continue;
            }
            File file = new File(this.m_refDir, classPathStrings[i]);
            if (BundleCache.getSecureAction().isFileDirectory(file)) {
                contentList.add(new DirectoryContent(file));
                continue;
            }
            if (!BundleCache.getSecureAction().fileExists(file)) continue;
            contentList.add(new JarContent(file));
        }
        if (contentList.size() == 0) {
            contentList.add(self);
        }
        return contentList.toArray(new IContent[contentList.size()]);
    }

    public String findLibrary(String libName) throws Exception {
        String result = BundleCache.getSecureAction().getAbsolutePath(new File(this.m_refDir, libName));
        if (result == null) {
            throw new IOException("No such file: " + libName);
        }
        return result;
    }

    public void dispose() throws Exception {
    }
}

