/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.main;

import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.startlevel.StartLevel;

public class AutoActivator
implements BundleActivator {
    public static final String AUTO_INSTALL_PROP = "felix.auto.install";
    public static final String AUTO_START_PROP = "felix.auto.start";
    private Map m_configMap;
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;

    public AutoActivator(Map configMap) {
        this.m_configMap = configMap;
    }

    public void start(BundleContext context) {
        this.processAutoProperties(context);
    }

    public void stop(BundleContext context) {
    }

    private void processAutoProperties(BundleContext context) {
        String key;
        StartLevel sl = (StartLevel)context.getService(context.getServiceReference((class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = AutoActivator.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName()));
        Iterator i = this.m_configMap.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (!key.startsWith(AUTO_INSTALL_PROP) && !key.startsWith(AUTO_START_PROP)) continue;
            int startLevel = sl.getInitialBundleStartLevel();
            if (!key.equals(AUTO_INSTALL_PROP) && !key.equals(AUTO_START_PROP)) {
                try {
                    startLevel = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid property: " + key);
                }
            }
            StringTokenizer st = new StringTokenizer((String)this.m_configMap.get(key), "\" ", true);
            String location = AutoActivator.nextLocation(st);
            while (location != null) {
                try {
                    Bundle b = context.installBundle(location, null);
                    sl.setBundleStartLevel(b, startLevel);
                }
                catch (Exception ex) {
                    System.err.println("Auto-properties install: " + ex);
                }
                location = AutoActivator.nextLocation(st);
            }
        }
        i = this.m_configMap.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (!key.startsWith(AUTO_START_PROP)) continue;
            StringTokenizer st = new StringTokenizer((String)this.m_configMap.get(key), "\" ", true);
            String location = AutoActivator.nextLocation(st);
            while (location != null) {
                try {
                    Bundle b = context.installBundle(location, null);
                    if (b != null) {
                        b.start();
                    }
                }
                catch (Exception ex) {
                    System.err.println("Auto-properties start: " + ex);
                }
                location = AutoActivator.nextLocation(st);
            }
        }
    }

    private static String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuffer tokBuf = new StringBuffer(10);
            String tok = null;
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            while (st.hasMoreTokens() && !exit) {
                tok = st.nextToken(tokenList);
                if (tok.equals("\"")) {
                    boolean bl = inQuote = !inQuote;
                    if (inQuote) {
                        tokenList = "\"";
                        continue;
                    }
                    tokenList = "\" ";
                    continue;
                }
                if (tok.equals(" ")) {
                    if (!tokStarted) continue;
                    retVal = tokBuf.toString();
                    tokStarted = false;
                    tokBuf = new StringBuffer(10);
                    exit = true;
                    continue;
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

