/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.versioning;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Request;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.buf.MessageBytes;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.web.base.BaseWebContainerService;
import org.ow2.jonas.web.tomcat6.versioning.VersionedPathBean;
import org.ow2.jonas.web.tomcat6.versioning.VirtualContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextFinder {
    private static Log logger = LogFactory.getLog(ContextFinder.class);
    private static Map<String, VirtualContext> contextURIMapping = new HashMap<String, VirtualContext>();
    private static JmxService jmxService = null;
    private static BaseWebContainerService webContainer = null;

    public static void setJmxService(JmxService jmxService) {
        ContextFinder.jmxService = jmxService;
    }

    private ContextFinder() {
    }

    public static void setParent(BaseWebContainerService webContainer) {
        ContextFinder.webContainer = webContainer;
    }

    public static MessageBytes getContextURI(MessageBytes decodedURI, Connector connector, Request req, VersionedPathBean vpb) throws IOException {
        MessageBytes contextURI = decodedURI;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting getContextURI...");
            logger.debug((Object)("\tdecodedURI = " + decodedURI.toString()));
            logger.debug((Object)("\tcontextURI = " + contextURI.toString()));
        }
        if (webContainer.isVersioningEnabled()) {
            String userPath;
            int decodedURILength = decodedURI.indexOf('/', 1);
            if (decodedURILength > 0) {
                userPath = new String(decodedURI.getCharChunk().getChars(), 0, decodedURILength);
            } else {
                userPath = new String(decodedURI.getCharChunk().getChars(), 0, decodedURI.getLength());
                if (vpb != null) {
                    vpb.setUserPathEndWithSlash(false);
                }
            }
            VirtualContext vctx = contextURIMapping.get(userPath);
            if (vctx != null) {
                contextURI = MessageBytes.newInstance();
                contextURI.duplicate(decodedURI);
                String versionedPath = vctx.findContext(req);
                StringBuffer versionedURI = new StringBuffer();
                if (versionedPath == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("No version found for virtual context : " + userPath));
                    }
                    versionedURI.append(userPath);
                    versionedURI.append("-invalid-version/");
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found versioned context : " + versionedPath));
                    }
                    if (vpb != null) {
                        vpb.setUserPath(userPath);
                        vpb.setVersionedPath(versionedPath);
                    }
                    versionedURI.append(versionedPath);
                    versionedURI.append('/');
                    if (decodedURI.getLength() - userPath.length() - 1 > 0) {
                        versionedURI.append(decodedURI.getCharChunk().getChars(), userPath.length() + 1, decodedURI.getLength() - userPath.length() - 1);
                    }
                }
                contextURI.setChars(versionedURI.toString().toCharArray(), 0, versionedURI.length());
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("No virtual context for URI : " + userPath));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Finished getContextURI");
            logger.debug((Object)("\tdecodedURI = " + decodedURI.toString()));
            logger.debug((Object)("\tcontextURI = " + contextURI.toString()));
        }
        return contextURI;
    }

    public static boolean bindContextRoot(String userURI, Context contextRoot, String policy) {
        if (webContainer.isVersioningEnabled()) {
            if (!contextURIMapping.containsKey(userURI)) {
                VirtualContext newContext = new VirtualContext(jmxService, userURI, contextRoot);
                contextURIMapping.put(userURI, newContext);
                webContainer.getVersioningService().addContext(newContext.getMBeanName());
            } else {
                contextURIMapping.get(userURI).addContext(contextRoot, policy);
            }
            return true;
        }
        return false;
    }

    public static Map<String, String> readContextRoot(String userContextRoot) {
        if (webContainer.isVersioningEnabled()) {
            VirtualContext context = contextURIMapping.get(userContextRoot);
            if (context == null) {
                return null;
            }
            return context.getContexts();
        }
        return null;
    }

    public static boolean unbindContextRoot(String userURI, Context contextRoot) {
        return ContextFinder.unbindContextRoot(userURI, contextRoot.getPath());
    }

    public static boolean unbindContextRoot(String userURI, String versionedPath) {
        if (webContainer.isVersioningEnabled()) {
            VirtualContext context = contextURIMapping.get(userURI);
            if (context == null) {
                return false;
            }
            return context.removeContext(versionedPath);
        }
        return false;
    }

    public static boolean unbindContextRoot(Context contextRoot) {
        return ContextFinder.unbindContextRoot(contextRoot.getPath());
    }

    public static boolean unbindContextRoot(String contextRoot) {
        if (webContainer.isVersioningEnabled()) {
            for (Map.Entry<String, VirtualContext> entry : contextURIMapping.entrySet()) {
                if (!entry.getValue().hasContext(contextRoot)) continue;
                return ContextFinder.unbindContextRoot(entry.getKey(), contextRoot);
            }
        }
        return false;
    }

    public static boolean unbindVirtualContext(String userURI) {
        if (webContainer.isVersioningEnabled()) {
            VirtualContext context = contextURIMapping.get(userURI);
            if (context == null) {
                return false;
            }
            contextURIMapping.remove(userURI);
            webContainer.getVersioningService().removeContext(context.getMBeanName());
            return context.removeVirtualContext();
        }
        return false;
    }
}

