/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.sql;

import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import javax.ejb.EJBObject;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.lib.JormPathHelper;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.lib.Abs;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.expression.lib.BasicOperand;
import org.objectweb.medor.expression.lib.BasicParameterOperand;
import org.objectweb.medor.expression.lib.Concat;
import org.objectweb.medor.expression.lib.DivideBy;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.medor.expression.lib.FirstLocate;
import org.objectweb.medor.expression.lib.Greater;
import org.objectweb.medor.expression.lib.GreaterEqual;
import org.objectweb.medor.expression.lib.IndexedLocate;
import org.objectweb.medor.expression.lib.Length;
import org.objectweb.medor.expression.lib.Like;
import org.objectweb.medor.expression.lib.Lower;
import org.objectweb.medor.expression.lib.LowerEqual;
import org.objectweb.medor.expression.lib.Minus;
import org.objectweb.medor.expression.lib.Mod;
import org.objectweb.medor.expression.lib.Mult;
import org.objectweb.medor.expression.lib.Not;
import org.objectweb.medor.expression.lib.NotEqual;
import org.objectweb.medor.expression.lib.Or;
import org.objectweb.medor.expression.lib.Plus;
import org.objectweb.medor.expression.lib.Sqrt;
import org.objectweb.medor.expression.lib.Substring;
import org.objectweb.medor.expression.lib.UMinus;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.jorm.lib.IsNullPName;
import org.objectweb.medor.filter.lib.BasicFieldOperand;
import org.objectweb.medor.filter.lib.CollectionOperand;
import org.objectweb.medor.filter.lib.InCollection;
import org.objectweb.medor.filter.lib.IsEmpty;
import org.objectweb.medor.filter.lib.IsNull;
import org.objectweb.medor.filter.lib.MemberOf;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.jorm.lib.PNameField;
import org.objectweb.medor.query.jorm.lib.QueryBuilder;
import org.objectweb.medor.type.lib.PTypeSpaceMedor;
import org.ow2.jonas.deployment.ejb.ejbql.ASTArithmeticExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTArithmeticFactor;
import org.ow2.jonas.deployment.ejb.ejbql.ASTArithmeticLiteral;
import org.ow2.jonas.deployment.ejb.ejbql.ASTArithmeticTerm;
import org.ow2.jonas.deployment.ejb.ejbql.ASTBetweenExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTBooleanExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTBooleanLiteral;
import org.ow2.jonas.deployment.ejb.ejbql.ASTCmpPathExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTCollectionMemberExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTCollectionValuedPathExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTComparisonExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTConditionalExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTConditionalFactor;
import org.ow2.jonas.deployment.ejb.ejbql.ASTConditionalTerm;
import org.ow2.jonas.deployment.ejb.ejbql.ASTDatetimeExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTEJBQL;
import org.ow2.jonas.deployment.ejb.ejbql.ASTEmptyCollectionComparisonExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTEntityBeanExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTFloatingPointLiteral;
import org.ow2.jonas.deployment.ejb.ejbql.ASTFunctionsReturningNumerics;
import org.ow2.jonas.deployment.ejb.ejbql.ASTFunctionsReturningStrings;
import org.ow2.jonas.deployment.ejb.ejbql.ASTIdentificationVariable;
import org.ow2.jonas.deployment.ejb.ejbql.ASTInExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTInputParameter;
import org.ow2.jonas.deployment.ejb.ejbql.ASTIntegerLiteral;
import org.ow2.jonas.deployment.ejb.ejbql.ASTLikeExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTLiteral;
import org.ow2.jonas.deployment.ejb.ejbql.ASTNullComparisonExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTPath;
import org.ow2.jonas.deployment.ejb.ejbql.ASTSingleValuedCmrPathExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTSingleValuedPathExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTStringExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTStringLiteral;
import org.ow2.jonas.deployment.ejb.ejbql.ASTWhereClause;
import org.ow2.jonas.deployment.ejb.ejbql.ParseException;
import org.ow2.jonas.deployment.ejb.ejbql.SimpleNode;
import org.ow2.jonas.lib.ejb21.jorm.JormType;
import org.ow2.jonas.lib.ejb21.sql.EjbqlAbstractVisitor;

public class EjbqlQueryFilterVisitor
extends EjbqlAbstractVisitor {
    Expression qf = null;
    PMapper mapper = null;
    Map fields = null;
    Class[] parameterTypes;
    QueryBuilder qb;
    static final String OP_IGNORE = "ignore";

    public EjbqlQueryFilterVisitor(PMapper _mapper, Map _fields, Class[] parameterTypes, ASTEJBQL ejbql, QueryBuilder qb) throws Exception {
        this.mapper = _mapper;
        this.fields = _fields;
        this.parameterTypes = parameterTypes;
        this.qb = qb;
        this.visit((SimpleNode)ejbql);
    }

    public Expression getQueryFilter() {
        return this.qf;
    }

    public Object visit(ASTWhereClause node, Object data) {
        this.visit((SimpleNode)node, data);
        this.qf = OP_IGNORE.equals(((Stack)data).peek()) ? null : (Expression)((Stack)data).pop();
        return null;
    }

    public Object visit(ASTSingleValuedPathExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        try {
            String path = (String)((ASTPath)((Stack)data).pop()).value;
            Field f = (Field)this.fields.get(path);
            ((Stack)data).push(new BasicFieldOperand(f));
        }
        catch (Exception e) {
            throw new EjbqlAbstractVisitor.VisitorException(e);
        }
        return null;
    }

    public Object visit(ASTCmpPathExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        try {
            String path = (String)((ASTPath)((Stack)data).pop()).value;
            Field f = (Field)this.fields.get(path);
            ((Stack)data).push(new BasicFieldOperand(f));
        }
        catch (Exception e) {
            throw new EjbqlAbstractVisitor.VisitorException(e);
        }
        return null;
    }

    public Object visit(ASTSingleValuedCmrPathExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        try {
            String path = (String)((ASTPath)((Stack)data).pop()).value;
            Field f = (Field)this.fields.get(path);
            ((Stack)data).push(new BasicFieldOperand(f));
        }
        catch (Exception e) {
            throw new EjbqlAbstractVisitor.VisitorException(e);
        }
        return null;
    }

    public Object visit(ASTCollectionValuedPathExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        try {
            String path = (String)((ASTPath)((Stack)data).pop()).value;
            String[] parts = this.splitPath(path);
            String first = parts[0];
            String rest = this.mergePath(parts, 1, parts.length - 1);
            QueryBuilder subquery = new QueryBuilder(this.qb);
            subquery.define("", this.qb.navigate(first));
            QueryTreeField f = subquery.project(subquery.navigate(rest));
            ((Stack)data).push(new BasicFieldOperand((Field)f));
        }
        catch (Exception e) {
            throw new EjbqlAbstractVisitor.VisitorException(e);
        }
        return null;
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        Object ret = ((Stack)data).pop();
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            if (OP_IGNORE.equals(ret)) {
                ret = ((Stack)data).pop();
                continue;
            }
            if (OP_IGNORE.equals(((Stack)data).peek())) {
                ((Stack)data).pop();
                continue;
            }
            ret = new Or((Expression)((Stack)data).pop(), (Expression)ret);
        }
        ((Stack)data).push(ret);
        return null;
    }

    public Object visit(ASTConditionalTerm node, Object data) {
        this.visit((SimpleNode)node, data);
        Object ret = ((Stack)data).pop();
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            if (OP_IGNORE.equals(ret)) {
                ret = ((Stack)data).pop();
                continue;
            }
            if (OP_IGNORE.equals(((Stack)data).peek())) {
                ((Stack)data).pop();
                continue;
            }
            ret = new And((Expression)((Stack)data).pop(), (Expression)ret);
        }
        ((Stack)data).push(ret);
        return null;
    }

    public Object visit(ASTConditionalFactor node, Object data) {
        this.visit((SimpleNode)node, data);
        if (node.not && !OP_IGNORE.equals(((Stack)data).peek())) {
            Expression ret = (Expression)((Stack)data).pop();
            ((Stack)data).push(new Not(ret));
        }
        return null;
    }

    public Object visit(ASTBetweenExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        Expression[] terms = new Expression[3];
        terms[2] = (Expression)((Stack)data).pop();
        terms[1] = (Expression)((Stack)data).pop();
        terms[0] = (Expression)((Stack)data).pop();
        if (node.not) {
            ((Stack)data).push(new Or((Expression)new Lower(terms[0], terms[1]), (Expression)new Greater(terms[0], terms[2])));
        } else {
            ((Stack)data).push(new And((Expression)new GreaterEqual(terms[0], terms[1]), (Expression)new LowerEqual(terms[0], terms[2])));
        }
        return null;
    }

    public Object visit(ASTInExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack s = (Stack)data;
        ArrayList c = new ArrayList();
        for (int i = 1; i <= node.eltnum; ++i) {
            c.add(s.pop());
        }
        CollectionOperand co = new CollectionOperand(c);
        FieldOperand f = (FieldOperand)s.pop();
        if (node.not) {
            s.push(new Not((Expression)new InCollection(f, (Operand)co, f.getField().getType())));
        } else {
            s.push(new InCollection(f, (Operand)co, f.getField().getType()));
        }
        return null;
    }

    public Object visit(ASTLikeExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack s = (Stack)data;
        Expression e1 = (Expression)s.pop();
        Expression e2 = (Expression)s.pop();
        Expression e3 = null;
        if (node.third) {
            e3 = (Expression)s.pop();
        }
        if (e3 == null) {
            s.push(new Like(e2, e1, node.not));
        } else {
            s.push(new Like(e3, e2, e1, node.not));
        }
        return null;
    }

    public Object visit(ASTNullComparisonExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack s = (Stack)data;
        Expression e1 = (Expression)s.pop();
        if (e1 instanceof BasicParameterOperand && e1.getType().getTypeCode() == 202) {
            if (node.not) {
                s.push(new Not((Expression)new IsNullPName(((BasicParameterOperand)e1).getName())));
            } else {
                s.push(new IsNullPName(((BasicParameterOperand)e1).getName()));
            }
        } else if (e1.getType().getTypeCode() == 23) {
            BasicOperand op2;
            Field f = ((FieldOperand)e1).getField();
            PNameField pnf = null;
            if (f instanceof PNameField) {
                pnf = (PNameField)f;
            } else if (f instanceof PropagatedField) {
                pnf = (PNameField)((PropagatedField)f).getOriginFields()[0];
            } else {
                throw new Error("Operand of IS NULL not valid !?");
            }
            if (this.mapper == null) {
                op2 = new BasicOperand("pnamenull");
            } else {
                PName pnamenull = JormPathHelper.getPNameCoder((String)pnf.getPNamingContextParameter(), (PMapper)this.mapper).getNull();
                op2 = new BasicOperand((Object)pnamenull, PTypeSpaceMedor.PNAME);
            }
            if (node.not) {
                s.push(new Not((Expression)new Equal(e1, (Expression)op2)));
            } else {
                s.push(new Equal(e1, (Expression)op2));
            }
        } else if (node.not) {
            s.push(new Not((Expression)new IsNull(e1)));
        } else {
            s.push(new IsNull(e1));
        }
        return null;
    }

    public Object visit(ASTEmptyCollectionComparisonExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack s = (Stack)data;
        Expression e = (Expression)s.pop();
        IsEmpty res = new IsEmpty(e);
        if (node.not) {
            res = new Not((Expression)res);
        }
        s.push(res);
        return null;
    }

    public Object visit(ASTCollectionMemberExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack s = (Stack)data;
        Expression e2 = (Expression)s.pop();
        Expression e1 = (Expression)s.pop();
        ArrayList<Expression> le2 = new ArrayList<Expression>();
        le2.add(e2);
        ArrayList<Expression> le1 = new ArrayList<Expression>();
        le1.add(e1);
        MemberOf res = null;
        try {
            res = new MemberOf(le1, le2);
        }
        catch (MalformedExpressionException e) {
            throw new Error("Operand expression of MEMBER OF malformed: " + (Object)((Object)e) + e.getNestedException());
        }
        if (node.not) {
            s.push(new Not((Expression)res));
        } else {
            s.push(res);
        }
        return null;
    }

    public Object visit(ASTComparisonExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        Expression[] terms = new Expression[2];
        terms[1] = (Expression)((Stack)data).pop();
        terms[0] = (Expression)((Stack)data).pop();
        int op = (Integer)node.ops.get(0);
        switch (op) {
            case 9: {
                ((Stack)data).push(new Equal(terms[0], terms[1]));
                break;
            }
            case 16: {
                ((Stack)data).push(new NotEqual(terms[0], terms[1]));
                break;
            }
            case 13: {
                ((Stack)data).push(new Greater(terms[0], terms[1]));
                break;
            }
            case 7: {
                ((Stack)data).push(new GreaterEqual(terms[0], terms[1]));
                break;
            }
            case 18: {
                ((Stack)data).push(new Lower(terms[0], terms[1]));
                break;
            }
            case 10: {
                ((Stack)data).push(new LowerEqual(terms[0], terms[1]));
            }
        }
        return null;
    }

    public Object visit(ASTArithmeticExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        Expression ret = (Expression)((Stack)data).pop();
        block4: for (int i = 0; i < node.jjtGetNumChildren() - 1; ++i) {
            switch ((Integer)node.ops.get(node.jjtGetNumChildren() - 2 - i)) {
                case 8: {
                    ret = new Plus((Expression)((Stack)data).pop(), ret);
                    continue block4;
                }
                case 5: {
                    ret = new Minus((Expression)((Stack)data).pop(), ret);
                }
            }
        }
        ((Stack)data).push(ret);
        return null;
    }

    public Object visit(ASTArithmeticTerm node, Object data) {
        this.visit((SimpleNode)node, data);
        Expression ret = (Expression)((Stack)data).pop();
        block4: for (int i = 0; i < node.jjtGetNumChildren() - 1; ++i) {
            switch ((Integer)node.ops.get(node.jjtGetNumChildren() - 2 - i)) {
                case 6: {
                    ret = new Mult((Expression)((Stack)data).pop(), ret);
                    continue block4;
                }
                case 11: {
                    ret = new DivideBy((Expression)((Stack)data).pop(), ret);
                }
            }
        }
        ((Stack)data).push(ret);
        return null;
    }

    public Object visit(ASTArithmeticFactor node, Object data) {
        this.visit((SimpleNode)node, data);
        Expression ret = (Expression)((Stack)data).pop();
        if (node.ops.size() > 0 && (Integer)node.ops.get(0) == 5) {
            ret = new UMinus(ret);
        }
        ((Stack)data).push(ret);
        return null;
    }

    public Object visit(ASTStringExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        return null;
    }

    public Object visit(ASTDatetimeExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        return null;
    }

    public Object visit(ASTBooleanExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        return null;
    }

    public Object visit(ASTEntityBeanExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        return null;
    }

    public Object visit(ASTFunctionsReturningStrings node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack s = (Stack)data;
        int op = (Integer)node.ops.get(0);
        Concat ret = null;
        switch (op) {
            case 25: {
                Expression e2 = (Expression)s.pop();
                Expression e1 = (Expression)s.pop();
                ret = new Concat(e1, e2);
                break;
            }
            case 50: {
                Expression e3 = (Expression)s.pop();
                Expression e2 = (Expression)s.pop();
                Expression e1 = (Expression)s.pop();
                ret = new Substring(e1, e2, e3);
            }
        }
        s.push(ret);
        return null;
    }

    public Object visit(ASTFunctionsReturningNumerics node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack s = (Stack)data;
        int op = (Integer)node.ops.get(0);
        Length ret = null;
        switch (op) {
            case 34: {
                Expression e1 = (Expression)s.pop();
                ret = new Length(e1);
                break;
            }
            case 37: {
                Expression e3 = null;
                if (node.third) {
                    e3 = (Expression)s.pop();
                }
                Expression e2 = (Expression)s.pop();
                Expression e1 = (Expression)s.pop();
                if (node.third) {
                    ret = new IndexedLocate(e2, e1, e3);
                    break;
                }
                ret = new FirstLocate(e1, e2);
                break;
            }
            case 19: {
                Expression e1 = (Expression)s.pop();
                ret = new Abs(e1);
                break;
            }
            case 49: {
                Expression e1 = (Expression)s.pop();
                ret = new Sqrt(e1);
                break;
            }
            case 41: {
                Expression e2 = (Expression)s.pop();
                Expression e1 = (Expression)s.pop();
                ret = new Mod(e1, e2);
            }
        }
        s.push(ret);
        return null;
    }

    public Object visit(ASTIdentificationVariable node, Object data) {
        String vName = ((String)node.value).toLowerCase();
        String fieldname = vName + "." + "_PName";
        Field f = (Field)this.fields.get(fieldname);
        ((Stack)data).push(new BasicFieldOperand(f));
        return null;
    }

    public Object visit(ASTLiteral node, Object data) {
        this.visit((SimpleNode)node, data);
        return null;
    }

    public Object visit(ASTStringLiteral node, Object data) {
        ((Stack)data).push(new BasicOperand((String)node.value));
        return null;
    }

    public Object visit(ASTArithmeticLiteral node, Object data) {
        this.visit((SimpleNode)node, data);
        return null;
    }

    public Object visit(ASTIntegerLiteral node, Object data) {
        ((Stack)data).push(new BasicOperand(((Long)node.value).longValue()));
        return null;
    }

    public Object visit(ASTFloatingPointLiteral node, Object data) {
        ((Stack)data).push(new BasicOperand(((Double)node.value).doubleValue()));
        return null;
    }

    public Object visit(ASTBooleanLiteral node, Object data) {
        ((Stack)data).push(new BasicOperand(((Boolean)node.value).booleanValue()));
        return null;
    }

    public Object visit(ASTInputParameter node, Object data) {
        try {
            int pIndex = (Integer)node.value - 1;
            if (pIndex >= this.parameterTypes.length) {
                throw new ParseException("Parameter ?" + (pIndex + 1) + " is out of range (max = " + this.parameterTypes.length + ")");
            }
            if (EJBObject.class.isAssignableFrom(this.parameterTypes[pIndex])) {
                throw new Error("EJBObject params not implemented");
            }
            BasicParameterOperand op = new BasicParameterOperand(JormType.getPType(this.parameterTypes[pIndex], false), "?" + node.value);
            ((Stack)data).push(op);
            return null;
        }
        catch (ParseException e) {
            throw new EjbqlAbstractVisitor.VisitorException((Exception)((Object)e));
        }
    }

    public Object visit(ASTPath node, Object data) {
        ((Stack)data).push(node);
        return null;
    }
}

