/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.sql;

import java.util.Map;
import java.util.Stack;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.filter.api.AggregateOperator;
import org.objectweb.medor.filter.lib.Avg;
import org.objectweb.medor.filter.lib.BasicFieldOperand;
import org.objectweb.medor.filter.lib.Count;
import org.objectweb.medor.filter.lib.Max;
import org.objectweb.medor.filter.lib.Min;
import org.objectweb.medor.filter.lib.Sum;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.Nest;
import org.objectweb.medor.query.lib.SelectProject;
import org.ow2.jonas.deployment.ejb.ejbql.ASTAggregateSelectExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTCmpPathExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTEJBQL;
import org.ow2.jonas.deployment.ejb.ejbql.ASTIdentificationVariable;
import org.ow2.jonas.deployment.ejb.ejbql.ASTPath;
import org.ow2.jonas.deployment.ejb.ejbql.ASTSelectClause;
import org.ow2.jonas.deployment.ejb.ejbql.ASTSelectExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTSingleValuedCmrPathExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ASTSingleValuedPathExpression;
import org.ow2.jonas.deployment.ejb.ejbql.SimpleNode;
import org.ow2.jonas.lib.ejb21.sql.EjbqlAbstractVisitor;

public class EjbqlSelectVisitor
extends EjbqlAbstractVisitor {
    Map fields;
    AggregateOperator aggregateOp = null;
    QueryTree qt;

    public EjbqlSelectVisitor(ASTEJBQL ejbql, Map _fields, SelectProject sp) throws Exception {
        this.qt = sp;
        this.fields = _fields;
        this.visit((SimpleNode)ejbql);
    }

    public QueryTree getQueryTree() {
        return this.qt;
    }

    public Object visit(ASTSelectClause node, Object data) {
        this.visit((SimpleNode)node, data);
        try {
            boolean distinct = node.distinct;
            this.qt.setDistinct(distinct);
            SelectProject sp = (SelectProject)this.qt;
            QueryTreeField qtf = (QueryTreeField)this.fields.get((String)((Stack)data).pop());
            PropagatedField qtf2 = sp.addPropagatedField(qtf.getName(), qtf.getType(), new QueryTreeField[]{qtf});
            if (this.aggregateOp != null) {
                Nest n = new Nest(new QueryTreeField[]{qtf2}, "grouped_fields", new QueryTreeField[0], "aggregate_node");
                PType type = null;
                if (this.aggregateOp instanceof Sum) {
                    type = qtf.getType().equals((Object)PTypeSpace.FLOAT) || qtf.getType().equals((Object)PTypeSpace.DOUBLE) ? PTypeSpace.DOUBLE : (qtf.getType().equals((Object)PTypeSpace.BIGINTEGER) ? PTypeSpace.BIGINTEGER : (qtf.getType().equals((Object)PTypeSpace.BIGDECIMAL) ? PTypeSpace.BIGDECIMAL : PTypeSpace.LONG));
                } else if (this.aggregateOp instanceof Max || this.aggregateOp instanceof Min) {
                    type = qtf.getType();
                } else if (this.aggregateOp instanceof Avg) {
                    type = PTypeSpace.DOUBLE;
                } else if (this.aggregateOp instanceof Count) {
                    type = PTypeSpace.LONG;
                }
                this.aggregateOp.setExpression(0, (Expression)new BasicFieldOperand((Field)qtf2));
                n.addCalculatedField("calculed_field", type, (Expression)this.aggregateOp);
                this.qt = n;
            }
        }
        catch (Exception e) {
            throw new EjbqlAbstractVisitor.VisitorException(e);
        }
        return null;
    }

    public Object visit(ASTSelectExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTAggregateSelectExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack s = (Stack)data;
        int operator = (Integer)node.ops.get(0);
        boolean distinct = node.distinct;
        Field field = (Field)this.fields.get((String)s.peek());
        BasicFieldOperand fieldOp = new BasicFieldOperand(field);
        switch (operator) {
            case 23: {
                this.aggregateOp = new Avg((Expression)fieldOp, distinct);
                break;
            }
            case 26: {
                this.aggregateOp = new Count((Expression)fieldOp, distinct);
                break;
            }
            case 38: {
                this.aggregateOp = new Max((Expression)fieldOp, distinct);
                break;
            }
            case 40: {
                this.aggregateOp = new Min((Expression)fieldOp, distinct);
                break;
            }
            case 51: {
                this.aggregateOp = new Sum((Expression)fieldOp, distinct);
                break;
            }
            default: {
                throw new Error("AggregateOperator '" + operator + "' unknown");
            }
        }
        return null;
    }

    public Object visit(ASTCmpPathExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTSingleValuedCmrPathExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTSingleValuedPathExpression node, Object data) {
        return this.visit((SimpleNode)node, data);
    }

    public Object visit(ASTIdentificationVariable node, Object data) {
        String vName = ((String)node.value).toLowerCase();
        ((Stack)data).push(vName + "." + "_PName");
        return null;
    }

    public Object visit(ASTPath node, Object data) {
        ((Stack)data).push(node.value);
        return null;
    }
}

