/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.versioning.internal;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.management.ObjectName;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.versioning.internal.VersioningServiceImplMBean;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningServiceImpl
extends AbsServiceImpl
implements VersioningService,
VersioningServiceImplMBean,
Pojo {
    private InstanceManager _cm;
    private static Log logger = LogFactory.getLog(VersioningService.class);
    private boolean _FdefaultPolicy;
    private String defaultPolicy;
    private boolean _Fcontexts;
    private List<String> contexts;
    private boolean _FjmxService;
    private JmxService jmxService;
    private boolean _M$initorg_apache_felix_ipojo_InstanceManager;
    private boolean _MsetJmxServiceorg_ow2_jonas_jmx_JmxService;
    private boolean _MdoStart;
    private boolean _MdoStop;
    private boolean _MgetDefaultPolicy;
    private boolean _MsetDefaultPolicyjava_lang_String;
    private boolean _MisVersioningEnabled;
    private boolean _MaddContextjava_lang_String;
    private boolean _MremoveContextjava_lang_String;
    private boolean _MgetContexts;
    private boolean _MgetVersionIDjava_io_File;
    private boolean _MgetVersionIDjava_net_URL;
    private boolean _MgetVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable;

    private String _getdefaultPolicy() {
        if (!this._FdefaultPolicy) {
            return this.defaultPolicy;
        }
        return (String)this._cm.getterCallback("defaultPolicy");
    }

    private void _setdefaultPolicy(String string) {
        if (!this._FdefaultPolicy) {
            this.defaultPolicy = string;
            return;
        }
        this._cm.setterCallback("defaultPolicy", (Object)string);
    }

    private List _getcontexts() {
        if (!this._Fcontexts) {
            return this.contexts;
        }
        return (List)this._cm.getterCallback("contexts");
    }

    private void _setcontexts(List list) {
        if (!this._Fcontexts) {
            this.contexts = list;
            return;
        }
        this._cm.setterCallback("contexts", (Object)list);
    }

    private JmxService _getjmxService() {
        if (!this._FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this._cm.getterCallback("jmxService");
    }

    private void _setjmxService(JmxService jmxService) {
        if (!this._FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this._cm.setterCallback("jmxService", (Object)jmxService);
    }

    public VersioningServiceImpl(InstanceManager _manager) {
        this._setComponentManager(_manager);
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.entryCallback("$initorg_apache_felix_ipojo_InstanceManager");
        }
        this._setdefaultPolicy("Reserved");
        this._setcontexts(new ArrayList());
        this._setjmxService(null);
        Object var3_2 = null;
        if (this._M$initorg_apache_felix_ipojo_InstanceManager) {
            this._cm.exitCallback("$initorg_apache_felix_ipojo_InstanceManager", var3_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setJmxService(JmxService jmxService) {
        void jmxService2;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.entryCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService");
        }
        this._setjmxService((JmxService)jmxService2);
        Object var2_2 = null;
        if (this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService) {
            this._cm.exitCallback("setJmxServiceorg_ow2_jonas_jmx_JmxService", var2_2);
        }
    }

    public static ObjectName getObjectName(String domainName) {
        try {
            return ObjectName.getInstance(domainName + ":type=service,name=versioning");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get versioning service", e);
        }
    }

    protected void doStart() throws ServiceException {
        if (this._MdoStart) {
            this._cm.entryCallback("doStart");
        }
        try {
            this._getjmxService().registerMBean((Object)this, VersioningServiceImpl.getObjectName(this.getDomainName()));
            logger.info((Object)"Versioning service management bean has been registered successfully", new Object[0]);
        }
        catch (Exception e) {
            ServiceException serviceException = new ServiceException("Cannot register VersioningService MBean", (Throwable)e);
            if (this._MdoStart) {
                this._cm.exitCallback("doStart", (Object)serviceException);
            }
            throw serviceException;
        }
        Object var3_3 = null;
        if (this._MdoStart) {
            this._cm.exitCallback("doStart", var3_3);
        }
    }

    protected void doStop() throws ServiceException {
        if (this._MdoStop) {
            this._cm.entryCallback("doStop");
        }
        this._getjmxService().unregisterMBean(VersioningServiceImpl.getObjectName(this.getDomainName()));
        logger.info((Object)"Versioning service management bean has been unregistered successfully", new Object[0]);
        Object var1_1 = null;
        if (this._MdoStop) {
            this._cm.exitCallback("doStop", var1_1);
        }
    }

    @Override
    public String getDefaultPolicy() {
        if (this._MgetDefaultPolicy) {
            this._cm.entryCallback("getDefaultPolicy");
        }
        String string = this._getdefaultPolicy();
        if (this._MgetDefaultPolicy) {
            this._cm.exitCallback("getDefaultPolicy", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDefaultPolicy(String string) {
        void defaultPolicy;
        if (this._MsetDefaultPolicyjava_lang_String) {
            this._cm.entryCallback("setDefaultPolicyjava_lang_String");
        }
        this._setdefaultPolicy((String)defaultPolicy);
        Object var2_2 = null;
        if (this._MsetDefaultPolicyjava_lang_String) {
            this._cm.exitCallback("setDefaultPolicyjava_lang_String", var2_2);
        }
    }

    @Override
    public boolean isVersioningEnabled() {
        if (this._MisVersioningEnabled) {
            this._cm.entryCallback("isVersioningEnabled");
        }
        Boolean bl = new Boolean(this.isStarted());
        if (this._MisVersioningEnabled) {
            this._cm.exitCallback("isVersioningEnabled", (Object)bl);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addContext(String string) {
        void context;
        if (this._MaddContextjava_lang_String) {
            this._cm.entryCallback("addContextjava_lang_String");
        }
        this._getcontexts().add(context);
        Object var2_2 = null;
        if (this._MaddContextjava_lang_String) {
            this._cm.exitCallback("addContextjava_lang_String", var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeContext(String string) {
        void context;
        if (this._MremoveContextjava_lang_String) {
            this._cm.entryCallback("removeContextjava_lang_String");
        }
        this._getcontexts().remove(context);
        Object var2_2 = null;
        if (this._MremoveContextjava_lang_String) {
            this._cm.exitCallback("removeContextjava_lang_String", var2_2);
        }
    }

    @Override
    public String[] getContexts() {
        if (this._MgetContexts) {
            this._cm.entryCallback("getContexts");
        }
        String[] stringArray = this._getcontexts().toArray(new String[this._getcontexts().size()]);
        if (this._MgetContexts) {
            this._cm.exitCallback("getContexts", (Object)stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getVersionID(File file) {
        void file2;
        if (this._MgetVersionIDjava_io_File) {
            this._cm.entryCallback("getVersionIDjava_io_File");
        }
        String versionID = null;
        JarFile manifestWarFile = null;
        try {
            manifestWarFile = new JarFile((File)file2);
            Manifest warManifest = manifestWarFile.getManifest();
            if (null != warManifest) {
                versionID = warManifest.getMainAttributes().getValue("Implementation-Version");
            }
            if (versionID != null) {
                String allowedSpecialChars = "-_,.";
                boolean versionIDFiltered = false;
                StringBuffer versionIDFilter = new StringBuffer();
                for (char c : versionID.toCharArray()) {
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "-_,.".indexOf(c) >= 0) {
                        versionIDFilter.append(c);
                        continue;
                    }
                    versionIDFiltered = true;
                    versionIDFilter.append('-');
                }
                if (versionIDFiltered) {
                    versionID = versionIDFilter.toString();
                    logger.warn((Object)("Invalid characters detected in version ID for file " + file2 + ", setting version ID to " + versionID), new Object[0]);
                }
                versionID = "-version" + versionID;
            }
        }
        catch (Exception e) {
            logger.info((Object)("Failed reading version ID from file " + file2), new Object[]{e});
        }
        try {
            manifestWarFile.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        String string = versionID;
        if (this._MgetVersionIDjava_io_File) {
            this._cm.exitCallback("getVersionIDjava_io_File", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getVersionID(URL uRL) {
        String string;
        block4: {
            void url;
            if (this._MgetVersionIDjava_net_URL) {
                this._cm.entryCallback("getVersionIDjava_net_URL");
            }
            try {
                string = this.getVersionID(URLUtils.urlToFile((URL)url));
                if (!this._MgetVersionIDjava_net_URL) break block4;
            }
            catch (Exception e) {
                String string2 = this.getVersionID(new File(url.getFile()));
                if (this._MgetVersionIDjava_net_URL) {
                    this._cm.exitCallback("getVersionIDjava_net_URL", (Object)string2);
                }
                return string2;
            }
            this._cm.exitCallback("getVersionIDjava_net_URL", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getVersionID(IDeployable<?> iDeployable) {
        void deployable;
        if (this._MgetVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.entryCallback("getVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable");
        }
        String versionID = null;
        try {
            IDeployable originalDeployable = deployable;
            while (originalDeployable.getOriginalDeployable() != null) {
                try {
                    originalDeployable = (IDeployable)originalDeployable.getOriginalDeployable();
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
            versionID = this.getVersionID(originalDeployable.getArchive().getURL());
        }
        catch (Exception e) {
            logger.info((Object)("Failed reading version ID from deployable " + deployable), new Object[]{e});
        }
        String string = versionID;
        if (this._MgetVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable) {
            this._cm.exitCallback("getVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)string);
        }
        return string;
    }

    private void _setComponentManager(InstanceManager instanceManager) {
        this._cm = instanceManager;
        Set set = this._cm.getRegistredFields();
        if (set != null) {
            if (set.contains("contexts")) {
                this._Fcontexts = true;
            }
            if (set.contains("logger")) {
                this._Flogger = true;
            }
            if (set.contains("defaultPolicy")) {
                this._FdefaultPolicy = true;
            }
            if (set.contains("jmxService")) {
                this._FjmxService = true;
            }
        }
        if ((set = this._cm.getRegistredMethods()) != null) {
            if (set.contains("$initorg_apache_felix_ipojo_InstanceManager")) {
                this._M$initorg_apache_felix_ipojo_InstanceManager = true;
            }
            if (set.contains("setJmxServiceorg_ow2_jonas_jmx_JmxService")) {
                this._MsetJmxServiceorg_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("doStart")) {
                this._MdoStart = true;
            }
            if (set.contains("doStop")) {
                this._MdoStop = true;
            }
            if (set.contains("getDefaultPolicy")) {
                this._MgetDefaultPolicy = true;
            }
            if (set.contains("setDefaultPolicyjava_lang_String")) {
                this._MsetDefaultPolicyjava_lang_String = true;
            }
            if (set.contains("isVersioningEnabled")) {
                this._MisVersioningEnabled = true;
            }
            if (set.contains("addContextjava_lang_String")) {
                this._MaddContextjava_lang_String = true;
            }
            if (set.contains("removeContextjava_lang_String")) {
                this._MremoveContextjava_lang_String = true;
            }
            if (set.contains("getContexts")) {
                this._MgetContexts = true;
            }
            if (set.contains("getVersionIDjava_io_File")) {
                this._MgetVersionIDjava_io_File = true;
            }
            if (set.contains("getVersionIDjava_net_URL")) {
                this._MgetVersionIDjava_net_URL = true;
            }
            if (set.contains("getVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this._MgetVersionIDorg_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this._cm;
    }
}

