/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.irmi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteStub;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.ow2.carol.irmi.Ref;
import org.ow2.carol.irmi.Server;

public class PRO
implements PortableRemoteObjectDelegate {
    private Server server;
    private boolean started = false;

    protected PRO(Server server) {
        this.server = server;
    }

    public PRO() {
        this(new Server());
    }

    public void connect(Remote target, Remote source) throws RemoteException {
        RemoteStub tgt = (RemoteStub)target;
        RemoteStub src = (RemoteStub)source;
        Ref tgtRef = (Ref)tgt.getRef();
        Ref srcRef = (Ref)src.getRef();
        tgtRef.connect(srcRef);
    }

    public synchronized void exportObject(Remote obj) throws RemoteException {
        if (!this.started) {
            this.server.start();
            this.started = true;
        }
        this.server.export(obj);
    }

    public Object narrow(Object narrowFrom, Class narrowTo) {
        return narrowFrom;
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        if (!this.started) {
            throw new NoSuchObjectException("" + obj);
        }
        RemoteStub result = this.server.getStub(obj);
        if (result == null) {
            throw new NoSuchObjectException("" + obj);
        }
        return result;
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        if (!this.server.unexport(obj)) {
            throw new NoSuchObjectException("" + obj);
        }
    }
}

