/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.irmi;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteStub;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ow2.carol.irmi.Server;

public class RMIObjectOutputStream
extends ObjectOutputStream {
    private Map cache = new HashMap();
    private Set annotated = new HashSet();

    public RMIObjectOutputStream(OutputStream out) throws IOException {
        super(new BufferedOutputStream(out, 4096));
        this.enableReplaceObject(true);
    }

    protected void annotateClass(Class cl) throws IOException {
        if (this.annotated.contains(cl)) {
            return;
        }
        String annotation = RMIClassLoader.getClassAnnotation(cl);
        if (annotation == null) {
            annotation = "";
        }
        this.writeUTF(annotation);
        this.annotated.add(cl);
    }

    protected void annotateProxyClass(Class cl) throws IOException {
        this.annotateClass(cl);
    }

    protected Object replaceObject(Object obj) {
        if (obj instanceof RemoteStub) {
            return obj;
        }
        if (obj instanceof Remote) {
            Collection servers = Server.getServers();
            Iterator it = servers.iterator();
            while (it.hasNext()) {
                Server server = (Server)it.next();
                RemoteStub stub = server.getStub((Remote)obj);
                if (stub == null) continue;
                return stub;
            }
            return obj;
        }
        return obj;
    }

    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        Class<?> klass = desc.forClass();
        Integer num = (Integer)this.cache.get(klass);
        if (num == null) {
            num = new Integer(this.cache.size());
            this.cache.put(klass, num);
            this.writeShort(-1);
            super.writeClassDescriptor(desc);
        } else {
            this.writeShort(num);
        }
    }

    protected void writeStreamHeader() {
    }
}

