/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.parser;

import org.apache.felix.ipojo.metadata.Element;

public class FieldMetadata {
    private String m_name;
    private String m_type;

    FieldMetadata(Element metadata) {
        this.m_name = metadata.getAttribute("name");
        this.m_type = metadata.getAttribute("type");
    }

    public FieldMetadata(String field, String type) {
        this.m_name = field;
        this.m_type = type;
    }

    public String getFieldName() {
        return this.m_name;
    }

    public String getFieldType() {
        return this.m_type;
    }

    public String getReflectionType() {
        if (this.m_type.endsWith("[]") && this.m_type.indexOf(".") == -1) {
            String arr = "";
            for (int i = 0; i < this.m_type.length(); ++i) {
                if (this.m_type.charAt(i) != '[') continue;
                arr = arr + '[';
            }
            int index = this.m_type.indexOf(91);
            String t = this.m_type.substring(0, index);
            return arr + this.getInternalPrimitiveType(t);
        }
        if (this.m_type.endsWith("[]") && this.m_type.indexOf(".") != -1) {
            String arr = "";
            for (int i = 0; i < this.m_type.length(); ++i) {
                if (this.m_type.charAt(i) != '[') continue;
                arr = arr + '[';
            }
            int index = this.m_type.indexOf(91);
            String t = this.m_type.substring(0, index);
            return arr + "L" + t + ";";
        }
        if (!this.m_type.endsWith("[]")) {
            return this.m_type;
        }
        return null;
    }

    private String getInternalPrimitiveType(String string) {
        if (string.equalsIgnoreCase("boolean")) {
            return "Z";
        }
        if (string.equalsIgnoreCase("char")) {
            return "C";
        }
        if (string.equalsIgnoreCase("byte")) {
            return "B";
        }
        if (string.equalsIgnoreCase("short")) {
            return "S";
        }
        if (string.equalsIgnoreCase("int")) {
            return "I";
        }
        if (string.equalsIgnoreCase("float")) {
            return "F";
        }
        if (string.equalsIgnoreCase("long")) {
            return "J";
        }
        if (string.equalsIgnoreCase("double")) {
            return "D";
        }
        System.err.println("No primitive type found for " + this.m_type);
        return null;
    }
}

