/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.client;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.lb.data.PolicyData;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.ServerRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
final class ClientClusterViewCache {
    private final Map<String, PolicyData> policyData = new ConcurrentHashMap<String, PolicyData>();
    private final Map<String, Class<?>> itfNames = new ConcurrentHashMap();
    private final Set<String> replicatedObjects = Collections.synchronizedSet(new HashSet());
    private final Set<String> statefulObjects = Collections.synchronizedSet(new HashSet());
    private final Map<String, Class<? extends EJBObject>> businessNames = new ConcurrentHashMap<String, Class<? extends EJBObject>>();
    private final Map<String, Class<? extends IPolicy<?>>> policyClasses = new ConcurrentHashMap();
    private final Map<String, Class<? extends IStrategy<?>>> strategyClasses = new ConcurrentHashMap();
    private final Map<String, List<CMIReference>> cmiReferences = new ConcurrentHashMap<String, List<CMIReference>>();
    private final Map<ServerRef, Integer> loadFactors = new ConcurrentHashMap<ServerRef, Integer>();
    private final Map<String, Set<String>> applicationExceptionNames = new ConcurrentHashMap<String, Set<String>>();

    void setPolicyData(String objectName, PolicyData policyData) {
        this.policyData.put(objectName, policyData);
    }

    PolicyData getPolicyData(String objectName) {
        return this.policyData.get(objectName);
    }

    void setItfName(String objectName, Class<?> itfName) {
        this.itfNames.put(objectName, itfName);
    }

    Class<?> getItfName(String objectName) {
        return this.itfNames.get(objectName);
    }

    void setBusinessName(String objectName, Class<? extends EJBObject> businessName) {
        this.businessNames.put(objectName, businessName);
    }

    Class<? extends EJBObject> getBusinessName(String objectName) {
        return this.businessNames.get(objectName);
    }

    Class<? extends IPolicy<?>> getPolicyClass(String className) {
        return this.policyClasses.get(className);
    }

    void setPolicyClass(String className, Class<? extends IPolicy<?>> policyClass) {
        this.policyClasses.put(className, policyClass);
    }

    Class<? extends IStrategy<?>> getStrategyClass(String className) {
        return this.strategyClasses.get(className);
    }

    void setStrategyClass(String className, Class<? extends IStrategy<?>> strategyClass) {
        this.strategyClasses.put(className, strategyClass);
    }

    void setCMIReferences(String objectName, List<CMIReference> cmiReferences) {
        this.cmiReferences.put(objectName, cmiReferences);
    }

    List<CMIReference> getCMIReferences(String objectName) {
        return this.cmiReferences.get(objectName);
    }

    int getLoadFactor(ServerRef serverRef) {
        return this.loadFactors.get(serverRef);
    }

    void setLoadFactor(ServerRef serverRef, int loadFactor) {
        this.loadFactors.put(serverRef, loadFactor);
    }

    Set<ServerRef> getAddressesOfServer() {
        return this.loadFactors.keySet();
    }

    Set<String> getObjectNames() {
        return new HashSet<String>(this.itfNames.keySet());
    }

    boolean hasState(String objectName) {
        return this.statefulObjects.contains(objectName);
    }

    void setState(String objectName) {
        this.statefulObjects.add(objectName);
    }

    boolean isReplicated(String objectName) {
        return this.replicatedObjects.contains(objectName);
    }

    void setReplicated(String objectName) {
        this.replicatedObjects.add(objectName);
    }

    Set<String> getApplicationExceptionNames(String objectName) {
        return this.applicationExceptionNames.get(objectName);
    }

    void setApplicationExceptionNames(String objectName, Set<String> applicationExceptionNames) {
        this.applicationExceptionNames.put(objectName, applicationExceptionNames);
    }
}

