/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.lb.policy;

import java.util.List;
import java.util.Random;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.lb.LoadBalanceable;
import org.ow2.cmi.lb.NoLoadBalanceableException;
import org.ow2.cmi.lb.policy.AbstractPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.lb.strategy.NoStrategy;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class FirstAvailable<T extends LoadBalanceable>
extends AbstractPolicy<T> {
    private static final Log LOGGER = LogFactory.getLog(FirstAvailable.class);
    private T nodeSelected = null;
    private final Random nodeRandom = new Random();

    @Override
    public synchronized T choose(List<T> loadBalanceables) throws NoLoadBalanceableException {
        List<T> cmiRefsWithStrategy;
        if (loadBalanceables.size() == 0) {
            LOGGER.error((Object)"The given list is empty", new Object[0]);
            throw new NoLoadBalanceableException("The given list is empty");
        }
        IStrategy<T> strategy = this.getStrategy();
        if (strategy != null) {
            cmiRefsWithStrategy = strategy.choose(loadBalanceables);
            if (cmiRefsWithStrategy.isEmpty()) {
                cmiRefsWithStrategy = loadBalanceables;
            }
        } else {
            cmiRefsWithStrategy = loadBalanceables;
        }
        if (this.nodeSelected != null && cmiRefsWithStrategy.contains(this.nodeSelected)) {
            return this.nodeSelected;
        }
        int index = strategy != null && !(strategy instanceof NoStrategy) ? 0 : this.nodeRandom.nextInt(cmiRefsWithStrategy.size());
        this.nodeSelected = (LoadBalanceable)cmiRefsWithStrategy.get(index);
        LOGGER.debug((Object)"New reference selected {1} at index {0}", new Object[]{index, this.nodeSelected});
        return this.nodeSelected;
    }

    public String toString() {
        return "FirstAvailable[nodeSelected: " + this.nodeSelected + " - strategy: " + this.getStrategy() + "]";
    }
}

