/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.web;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ow2.jonas.deployment.web.TransportGuaranteeDesc;

public class MethodDesc {
    private String name = null;
    private boolean excluded = false;
    private boolean unchecked = true;
    private TransportGuaranteeDesc transportGuarantee;
    private List roles = null;

    public MethodDesc(String name) {
        this.name = name.toUpperCase();
        this.roles = new ArrayList();
        this.transportGuarantee = new TransportGuaranteeDesc();
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public boolean isUnchecked() {
        return this.unchecked;
    }

    public void setExcluded() {
        this.excluded = true;
        this.unchecked = false;
    }

    public void setUnchecked() {
        this.excluded = false;
        this.unchecked = true;
    }

    public void addTransportGuarantee(String transportGuaranteeValue) {
        this.transportGuarantee.addTransportValue(transportGuaranteeValue);
    }

    public void addRole(String role, String transportGuaranteeRoleValue) {
        if (!this.roles.contains(role)) {
            this.roles.add(role);
        }
        this.addTransportGuarantee(transportGuaranteeRoleValue);
    }

    public boolean hasRole() {
        return this.roles.size() > 0;
    }

    public String getName() {
        return this.name;
    }

    public Iterator getRolesIterator() {
        return this.roles.iterator();
    }

    public TransportGuaranteeDesc getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public boolean equals(Object other) {
        if (other instanceof String) {
            return this.name.equals(other);
        }
        if (other instanceof MethodDesc) {
            return this.name.equals(((MethodDesc)other).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Method[name=");
        sb.append(this.name);
        if (this.excluded) {
            sb.append(";excluded");
        }
        if (this.unchecked) {
            sb.append(";unchecked");
        }
        sb.append(this.transportGuarantee);
        sb.append(";roles=");
        Iterator it = this.getRolesIterator();
        while (it.hasNext()) {
            String role = (String)it.next();
            sb.append(role);
        }
        sb.append("]");
        return sb.toString();
    }
}

