/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.deployment.annotations.analyzer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ow2.util.deployment.annotations.analyzer.ArchiveHelper;
import org.ow2.util.ee.deploy.api.archive.ArchiveException;
import org.ow2.util.ee.deploy.api.archive.IArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultArchiveHelper
implements ArchiveHelper {
    private static final ArchiveHelper INSTANCE = new DefaultArchiveHelper();

    public static ArchiveHelper getInstance() {
        return INSTANCE;
    }

    protected DefaultArchiveHelper() {
    }

    @Override
    public URL getClassURL(IArchive archive, String className) throws ArchiveException {
        return archive.getResource(className.replace('.', '/').concat(".class"));
    }

    @Override
    public List<URL> listClassURL(IArchive archive) throws ArchiveException {
        ArrayList<URL> classURLList = new ArrayList<URL>();
        Iterator iterator = archive.getResources();
        while (iterator.hasNext()) {
            URL url = (URL)iterator.next();
            String className = url.getPath().toLowerCase();
            if (!className.endsWith(".class")) continue;
            classURLList.add(url);
        }
        return classURLList;
    }
}

