/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.StringId;
import fr.dyade.aaa.util.Pool;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

final class Message
implements Serializable {
    static final long serialVersionUID = 1L;
    transient AgentId from;
    transient AgentId to;
    transient Notification not;
    transient short source;
    transient short dest;
    transient int stamp;
    static final int LENGTH = 25;
    static final int PERSISTENT = 1;
    static final int DETACHABLE = 16;
    private transient byte[] iobuf = new byte[25];
    private transient String stringId = null;
    private static Pool pool = null;

    short getSource() {
        return this.source;
    }

    short getDest() {
        return this.dest;
    }

    int getStamp() {
        return this.stamp;
    }

    public String toString() {
        return this.appendToString(new StringBuffer()).toString();
    }

    public StringBuffer appendToString(StringBuffer strbuf) {
        strbuf.append('(').append(super.toString());
        strbuf.append(",from=").append(this.from);
        strbuf.append(",to=").append(this.to);
        strbuf.append(",not=").append(this.not);
        strbuf.append(",source=").append(this.source);
        strbuf.append(",dest=").append(this.dest);
        strbuf.append(",stamp=").append(this.stamp);
        strbuf.append(')');
        return strbuf;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int idx = this.writeToBuf(this.iobuf, 0);
        this.iobuf[idx++] = (byte)((this.not.persistent ? 1 : 0) | (this.not.detachable ? 16 : 0));
        out.write(this.iobuf, 0, 25);
        if (!this.not.detachable) {
            out.writeObject(this.not);
        }
    }

    int writeToBuf(byte[] buf, int idx) {
        buf[idx++] = (byte)(this.from.from >>> 8);
        buf[idx++] = (byte)(this.from.from >>> 0);
        buf[idx++] = (byte)(this.from.to >>> 8);
        buf[idx++] = (byte)(this.from.to >>> 0);
        buf[idx++] = (byte)(this.from.stamp >>> 24);
        buf[idx++] = (byte)(this.from.stamp >>> 16);
        buf[idx++] = (byte)(this.from.stamp >>> 8);
        buf[idx++] = (byte)(this.from.stamp >>> 0);
        buf[idx++] = (byte)(this.to.from >>> 8);
        buf[idx++] = (byte)(this.to.from >>> 0);
        buf[idx++] = (byte)(this.to.to >>> 8);
        buf[idx++] = (byte)(this.to.to >>> 0);
        buf[idx++] = (byte)(this.to.stamp >>> 24);
        buf[idx++] = (byte)(this.to.stamp >>> 16);
        buf[idx++] = (byte)(this.to.stamp >>> 8);
        buf[idx++] = (byte)(this.to.stamp >>> 0);
        buf[idx++] = (byte)(this.source >>> 8);
        buf[idx++] = (byte)(this.source >>> 0);
        buf[idx++] = (byte)(this.dest >>> 8);
        buf[idx++] = (byte)(this.dest >>> 0);
        buf[idx++] = (byte)(this.stamp >>> 24);
        buf[idx++] = (byte)(this.stamp >>> 16);
        buf[idx++] = (byte)(this.stamp >>> 8);
        buf[idx++] = (byte)(this.stamp >>> 0);
        return idx;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean detachable;
        this.iobuf = new byte[25];
        in.readFully(this.iobuf, 0, 25);
        int idx = this.readFromBuf(this.iobuf, 0);
        boolean persistent = (this.iobuf[idx] & 1) != 0;
        boolean bl = detachable = (this.iobuf[idx] & 0x10) != 0;
        if (!detachable) {
            this.not = (Notification)in.readObject();
            this.not.detachable = false;
            this.not.detached = false;
        }
    }

    int readFromBuf(byte[] buf, int idx) {
        this.from = new AgentId((short)(((buf[idx++] & 0xFF) << 8) + (buf[idx++] & 0xFF)), (short)(((buf[idx++] & 0xFF) << 8) + (buf[idx++] & 0xFF)), ((buf[idx++] & 0xFF) << 24) + ((buf[idx++] & 0xFF) << 16) + ((buf[idx++] & 0xFF) << 8) + ((buf[idx++] & 0xFF) << 0));
        this.to = new AgentId((short)(((buf[idx++] & 0xFF) << 8) + (buf[idx++] & 0xFF)), (short)(((buf[idx++] & 0xFF) << 8) + (buf[idx++] & 0xFF)), ((buf[idx++] & 0xFF) << 24) + ((buf[idx++] & 0xFF) << 16) + ((buf[idx++] & 0xFF) << 8) + ((buf[idx++] & 0xFF) << 0));
        this.source = (short)(((buf[idx++] & 0xFF) << 8) + ((buf[idx++] & 0xFF) << 0));
        this.dest = (short)(((buf[idx++] & 0xFF) << 8) + ((buf[idx++] & 0xFF) << 0));
        this.stamp = ((buf[idx++] & 0xFF) << 24) + ((buf[idx++] & 0xFF) << 16) + ((buf[idx++] & 0xFF) << 8) + ((buf[idx++] & 0xFF) << 0);
        return idx;
    }

    final String toStringId() {
        if (this.stringId == null) {
            this.stringId = StringId.toStringId('@', '_', this.dest, this.stamp, -1);
        }
        return this.stringId;
    }

    boolean isPersistent() {
        return this.not != null && this.not.persistent;
    }

    void save() throws IOException {
        if (this.isPersistent()) {
            AgentServer.getTransaction().save(this, this.toStringId());
            if (this.not.detachable) {
                this.not.messageId = StringId.toStringId('N', '_', this.dest, this.stamp, -1);
                AgentServer.getTransaction().save(this.not, this.not.messageId);
            }
        }
    }

    static Message load(String name) throws IOException, ClassNotFoundException {
        Message msg = (Message)AgentServer.getTransaction().load(name);
        if (msg.not == null) {
            String messageId = StringId.toStringId('N', '_', msg.dest, msg.stamp, -1);
            msg.not = (Notification)AgentServer.getTransaction().load(messageId);
            msg.not.messageId = messageId;
            msg.not.detachable = true;
            msg.not.detached = false;
        }
        msg.not.persistent = true;
        return msg;
    }

    void delete() throws IOException {
        if (this.isPersistent()) {
            AgentServer.getTransaction().delete(this.toStringId());
            if (this.not.detachable && !this.not.detached) {
                AgentServer.getTransaction().delete(this.not.getMessageId());
            }
        }
    }

    private Message() {
    }

    static Message alloc() {
        Message msg = null;
        try {
            msg = (Message)pool.allocElement();
        }
        catch (Exception exc) {
            return new Message();
        }
        return msg;
    }

    static Message alloc(AgentId from, AgentId to, Notification not) {
        Message msg = Message.alloc();
        msg.set(from, to, not);
        return msg;
    }

    void free() {
        this.not = null;
        this.stringId = null;
        pool.freeElement(this);
    }

    private void set(AgentId from, AgentId to, Notification not) {
        this.from = from;
        this.to = to;
        if (not != null) {
            this.not = (Notification)not.clone();
            this.not.detached = not.detached;
            this.not.messageId = not.messageId;
        }
    }

    static {
        int size = Integer.getInteger("fr.dyade.aaa.agent.Message$Pool.size", 150);
        pool = new Pool("Message", size);
    }
}

