/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.ExpirationExceededException;
import fr.dyade.aaa.agent.JGroups;
import fr.dyade.aaa.agent.JGroupsAckMsg;
import fr.dyade.aaa.agent.Message;
import fr.dyade.aaa.agent.MessageVector;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.StreamNetwork;
import fr.dyade.aaa.agent.UnknownServerException;
import fr.dyade.aaa.util.Daemon;
import fr.dyade.aaa.util.SocketAddress;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class SimpleNetwork
extends StreamNetwork {
    MessageVector sendList;
    private JGroups jgroups = null;
    NetServerIn netServerIn = null;
    NetServerOut netServerOut = null;

    public void setJGroups(JGroups jgroups) {
        this.jgroups = jgroups;
    }

    void ackMsg(JGroupsAckMsg ack) {
        try {
            AgentServer.getTransaction().begin();
            this.qout.remove(ack.getStamp());
            ack.delete();
            AgentServer.getTransaction().commit(true);
            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ackMsg(...) done."));
            }
        }
        catch (Exception exc) {
            this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + ", ackMsg unrecoverable exception"), (Throwable)exc);
        }
    }

    public void start() throws IOException {
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", starting"));
        try {
            if (this.sendList == null) {
                this.sendList = new MessageVector(this.getName(), AgentServer.getTransaction().isPersistent());
            }
            if (this.netServerIn == null) {
                this.netServerIn = new NetServerIn(this.getName(), this.logmon);
            }
            if (this.netServerOut == null) {
                this.netServerOut = new NetServerOut(this.getName(), this.logmon);
            }
            if (!this.netServerIn.isRunning()) {
                this.netServerIn.start();
            }
            if (!this.netServerOut.isRunning()) {
                this.netServerOut.start();
            }
        }
        catch (IOException exc) {
            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't start"), (Throwable)exc);
            throw exc;
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", started"));
    }

    public void stop() {
        if (this.netServerIn != null) {
            this.netServerIn.stop();
        }
        if (this.netServerOut != null) {
            this.netServerOut.stop();
        }
        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", stopped"));
    }

    public boolean isRunning() {
        return this.netServerIn != null && this.netServerIn.isRunning() && this.netServerOut != null && this.netServerOut.isRunning();
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(super.toString()).append("\n\t");
        if (this.netServerIn != null) {
            strbuf.append(this.netServerIn.toString()).append("\n\t");
        }
        if (this.netServerOut != null) {
            strbuf.append(this.netServerOut.toString()).append("\n\t");
        }
        return strbuf.toString();
    }

    final class MessageOutputStream
    extends ByteArrayOutputStream {
        private ObjectOutputStream oos;
        private OutputStream os;

        MessageOutputStream() throws IOException {
            super(256);
            this.oos = null;
            this.os = null;
            this.oos = new ObjectOutputStream(this);
            this.count = 0;
            this.buf[29] = -84;
            this.buf[30] = -19;
            this.buf[31] = 0;
            this.buf[32] = 5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeMessage(Socket sock, Message msg, long currentTimeMillis) throws IOException {
            this.os = sock.getOutputStream();
            this.buf[0] = (byte)(SimpleNetwork.this.getBootTS() >>> 24);
            this.buf[1] = (byte)(SimpleNetwork.this.getBootTS() >>> 16);
            this.buf[2] = (byte)(SimpleNetwork.this.getBootTS() >>> 8);
            this.buf[3] = (byte)(SimpleNetwork.this.getBootTS() >>> 0);
            int idx = msg.writeToBuf(this.buf, 4);
            this.buf[idx++] = (byte)((msg.not.persistent ? 1 : 0) | (msg.not.detachable ? 16 : 0));
            this.count = 33;
            try {
                if (msg.not.expiration > 0L) {
                    msg.not.expiration -= currentTimeMillis;
                }
                this.oos.writeObject(msg.not);
                this.oos.reset();
                this.oos.flush();
                this.os.write(this.buf, 0, this.count);
                this.os.flush();
            }
            finally {
                if (msg.not.expiration > 0L) {
                    msg.not.expiration += currentTimeMillis;
                }
                this.count = 0;
            }
        }
    }

    final class NetServerIn
    extends Daemon {
        ServerSocket listen;

        NetServerIn(String name, Logger logmon) throws IOException {
            super(name + ".NetServerIn");
            this.listen = null;
            this.listen = SimpleNetwork.this.createServerSocket();
            this.logmon = logmon;
            this.setThreadGroup(AgentServer.getThreadGroup());
        }

        protected void close() {
            try {
                this.listen.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void shutdown() {
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Socket socket = null;
            OutputStream os = null;
            ObjectInputStream ois = null;
            byte[] iobuf = new byte[29];
            try {
                while (this.running) {
                    try {
                        int count;
                        this.canStop = true;
                        try {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting connection"));
                            }
                            socket = this.listen.accept();
                        }
                        catch (IOException exc) {
                            try {
                                os.close();
                            }
                            catch (Exception exc2) {
                                // empty catch block
                            }
                            os = null;
                            try {
                                ois.close();
                            }
                            catch (Exception exc3) {
                                // empty catch block
                            }
                            ois = null;
                            try {
                                socket.close();
                            }
                            catch (Exception exc4) {
                                // empty catch block
                            }
                            socket = null;
                            continue;
                        }
                        this.canStop = false;
                        SimpleNetwork.this.setSocketOption(socket);
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connected"));
                        }
                        os = socket.getOutputStream();
                        InputStream is = socket.getInputStream();
                        Message msg = Message.alloc();
                        int n = 0;
                        do {
                            if ((count = is.read(iobuf, n, 29 - n)) >= 0) continue;
                            throw new EOFException();
                        } while ((n += count) < 29);
                        int boot = ((iobuf[0] & 0xFF) << 24) + ((iobuf[1] & 0xFF) << 16) + ((iobuf[2] & 0xFF) << 8) + ((iobuf[3] & 0xFF) << 0);
                        int idx = msg.readFromBuf(iobuf, 4);
                        boolean persistent = (iobuf[idx] & 1) != 0;
                        boolean detachable = (iobuf[idx] & 0x10) != 0;
                        ois = new ObjectInputStream(is);
                        msg.not = (Notification)ois.readObject();
                        if (msg.not.expiration > 0L) {
                            msg.not.expiration += System.currentTimeMillis();
                        }
                        msg.not.persistent = persistent;
                        msg.not.detachable = detachable;
                        msg.not.detached = false;
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", msg received"));
                        }
                        SimpleNetwork.this.testBootTS(msg.getSource(), boot);
                        SimpleNetwork.this.deliver(msg);
                        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send ack"));
                        }
                        os.write(0);
                        os.flush();
                    }
                    catch (Exception exc) {
                        this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", closed"), (Throwable)exc);
                    }
                    finally {
                        try {
                            os.close();
                        }
                        catch (Exception exc) {}
                        os = null;
                        try {
                            ois.close();
                        }
                        catch (Exception exc) {}
                        ois = null;
                        try {
                            socket.close();
                        }
                        catch (Exception exc) {}
                        socket = null;
                    }
                }
            }
            finally {
                this.finish();
            }
        }
    }

    final class NetServerOut
    extends Daemon {
        MessageOutputStream nos;

        NetServerOut(String name, Logger logmon) {
            super(name + ".NetServerOut");
            this.nos = null;
            this.logmon = logmon;
            this.setThreadGroup(AgentServer.getThreadGroup());
        }

        protected void close() {
        }

        protected void shutdown() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Message msg = null;
            ServerDesc server = null;
            try {
                try {
                    this.nos = new MessageOutputStream();
                }
                catch (IOException exc) {
                    this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + ", cannot start."));
                    this.finish();
                    return;
                }
                while (this.running) {
                    block33: {
                        this.canStop = true;
                        try {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", waiting message"));
                            }
                            msg = SimpleNetwork.this.qout.get(SimpleNetwork.this.WDActivationPeriod);
                        }
                        catch (InterruptedException exc) {
                            if (!this.logmon.isLoggable(BasicLevel.DEBUG)) continue;
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", interrupted"));
                            continue;
                        }
                        this.canStop = false;
                        if (!this.running) {
                            break;
                        }
                        long currentTimeMillis = System.currentTimeMillis();
                        this.watchdog(currentTimeMillis);
                        if (msg == null) continue;
                        short msgto = msg.getDest();
                        Socket socket = null;
                        try {
                            if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", try to send message -> " + msg + "/" + msgto));
                            }
                            if (msg.not.expiration > 0L && msg.not.expiration < currentTimeMillis) {
                                throw new ExpirationExceededException();
                            }
                            server = AgentServer.getServerDesc(msgto);
                            try {
                                if (!server.active || server.last > currentTimeMillis) {
                                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", AgentServer#" + msgto + " is down"));
                                    }
                                    throw new ConnectException("AgentServer#" + msgto + " is down");
                                }
                                try {
                                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", try to connect"));
                                    }
                                    Enumeration e = server.getSockAddrs();
                                    while (e.hasMoreElements()) {
                                        SocketAddress sa = (SocketAddress)e.nextElement();
                                        try {
                                            server.moveToFirst(sa);
                                            socket = SimpleNetwork.this.createSocket(server);
                                        }
                                        catch (IOException ioexc) {
                                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connection refused with addr=" + server.getAddr() + " port=" + server.getPort() + ", try next element"));
                                            continue;
                                        }
                                        if (!this.logmon.isLoggable(BasicLevel.DEBUG)) break;
                                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", connected"));
                                        break;
                                    }
                                    if (socket == null) {
                                        socket = SimpleNetwork.this.createSocket(server);
                                    }
                                }
                                catch (IOException exc) {
                                    this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", connection refused"), (Throwable)exc);
                                    server.active = false;
                                    server.last = System.currentTimeMillis();
                                    ++server.retry;
                                    throw exc;
                                }
                                SimpleNetwork.this.setSocketOption(socket);
                            }
                            catch (IOException exc) {
                                this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", move msg in watchdog list"), (Throwable)exc);
                                SimpleNetwork.this.sendList.addMessage(msg);
                                SimpleNetwork.this.qout.pop();
                                continue;
                            }
                            try {
                                this.send(socket, msg, currentTimeMillis);
                            }
                            catch (IOException exc) {
                                this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", move msg in watchdog list"), (Throwable)exc);
                                SimpleNetwork.this.sendList.addMessage(msg);
                                SimpleNetwork.this.qout.pop();
                                continue;
                            }
                        }
                        catch (UnknownServerException exc) {
                            this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't send message: " + msg), (Throwable)exc);
                        }
                        catch (ExpirationExceededException exc) {
                            if (!this.logmon.isLoggable(BasicLevel.DEBUG)) break block33;
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": run : removes expired notification " + msg.from + ", " + msg.not));
                        }
                    }
                    AgentServer.getTransaction().begin();
                    SimpleNetwork.this.qout.pop();
                    if (SimpleNetwork.this.jgroups != null) {
                        SimpleNetwork.this.jgroups.send(new JGroupsAckMsg(msg));
                    }
                    msg.delete();
                    msg.free();
                    AgentServer.getTransaction().commit(true);
                }
            }
            catch (Exception exc) {
                this.logmon.log(BasicLevel.FATAL, (Object)(this.getName() + ", unrecoverable exception"), (Throwable)exc);
                AgentServer.stop(false);
            }
            finally {
                this.finish();
            }
        }

        void watchdog(long currentTimeMillis) throws IOException {
            ServerDesc server = null;
            for (int i = 0; i < SimpleNetwork.this.sendList.size(); ++i) {
                Message msg = SimpleNetwork.this.sendList.getMessageAt(i);
                short msgto = msg.getDest();
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", check msg#" + msg.getStamp() + " from " + msg.from + " to " + msg.to));
                }
                if (msg.not.expiration > 0L && msg.not.expiration < currentTimeMillis) {
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ": watchdog : removes expired notification " + msg.from + ", " + msg.not));
                    }
                    AgentServer.getTransaction().begin();
                    SimpleNetwork.this.sendList.removeMessageAt(i);
                    --i;
                    msg.delete();
                    msg.free();
                    AgentServer.getTransaction().commit(true);
                }
                try {
                    server = AgentServer.getServerDesc(msgto);
                }
                catch (UnknownServerException exc) {
                    this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", can't send message: " + msg), (Throwable)exc);
                    AgentServer.getTransaction().begin();
                    SimpleNetwork.this.sendList.removeMessageAt(i);
                    --i;
                    msg.delete();
                    msg.free();
                    AgentServer.getTransaction().commit(true);
                    continue;
                }
                if (server.last > currentTimeMillis) continue;
                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + server.active + ',' + server.retry + ',' + server.last + ',' + currentTimeMillis));
                if (!(server.active || server.retry < SimpleNetwork.this.WDNbRetryLevel1 && server.last + SimpleNetwork.this.WDRetryPeriod1 < currentTimeMillis || server.retry < SimpleNetwork.this.WDNbRetryLevel2 && server.last + SimpleNetwork.this.WDRetryPeriod2 < currentTimeMillis) && server.last + SimpleNetwork.this.WDRetryPeriod3 >= currentTimeMillis) continue;
                try {
                    if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                        this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", send msg#" + msg.getStamp()));
                    }
                    Socket socket = SimpleNetwork.this.createSocket(server);
                    server.active = true;
                    server.retry = 0;
                    server.last = currentTimeMillis;
                    SimpleNetwork.this.setSocketOption(socket);
                    this.send(socket, msg, currentTimeMillis);
                }
                catch (SocketException exc) {
                    if (this.logmon.isLoggable(BasicLevel.WARN)) {
                        this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", let msg in watchdog list"), (Throwable)exc);
                    }
                    server.active = false;
                    ++server.retry;
                    server.last = currentTimeMillis + 1L;
                    continue;
                }
                catch (Exception exc) {
                    this.logmon.log(BasicLevel.ERROR, (Object)(this.getName() + ", error"), (Throwable)exc);
                }
                AgentServer.getTransaction().begin();
                SimpleNetwork.this.sendList.removeMessageAt(i);
                --i;
                msg.delete();
                msg.free();
                AgentServer.getTransaction().commit(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(Socket socket, Message msg, long currentTimeMillis) throws IOException {
            InputStream is = null;
            try {
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", write message"));
                }
                this.nos.writeMessage(socket, msg, currentTimeMillis);
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", wait ack"));
                }
                if ((is = socket.getInputStream()).read() == -1) {
                    throw new ConnectException("Connection broken");
                }
                if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", receive ack"));
                }
            }
            finally {
                try {
                    socket.getOutputStream().close();
                }
                catch (Exception exc) {}
                try {
                    is.close();
                }
                catch (Exception exc) {}
                try {
                    socket.close();
                }
                catch (Exception exc) {}
            }
        }
    }
}

