/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import java.io.File;
import java.io.IOException;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Level;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.api.MonologFactory;

public class Debug {
    public static final boolean debug = true;
    public static final String DEBUG_DIR_PROPERTY = "fr.dyade.aaa.DEBUG_DIR";
    public static final String DEFAULT_DEBUG_DIR = ".";
    public static final String DEBUG_FILE_PROPERTY = "fr.dyade.aaa.DEBUG_FILE";
    public static final String DEFAULT_DEBUG_FILE = "a3debug.cfg";
    protected static LoggerFactory factory;
    private static String debugDir;
    private static String debugFileName;
    private static PrivateLogger logger;

    public static void setDebugDir(String debugDir) {
        Debug.debugDir = debugDir;
    }

    public static void setDebugFileName(String debugFileName) {
        Debug.debugFileName = debugFileName;
    }

    public static void reinit() throws Exception {
        Debug.initialize();
    }

    protected static void init() throws Exception {
        try {
            Debug.initialize();
        }
        catch (Exception exc) {
            System.err.println("Monolog configuration file not found, use defaults");
            try {
                ((MonologFactory)factory).configure(null);
                Logger[] loggers = factory.getLoggers();
                for (int i = 0; i < loggers.length; ++i) {
                    loggers[i].setIntLevel(BasicLevel.ERROR);
                }
            }
            catch (Exception e) {
                System.err.println("Unable to configure monolog wrapper");
                throw new Exception("Unable to configure monolog wrapper");
            }
        }
    }

    private static void initialize() throws Exception {
        String ldebugFileName;
        String ldebugDir = debugDir;
        if (ldebugDir == null) {
            ldebugDir = System.getProperty(DEBUG_DIR_PROPERTY);
        }
        if ((ldebugFileName = debugFileName) == null) {
            ldebugFileName = System.getProperty(DEBUG_FILE_PROPERTY, DEFAULT_DEBUG_FILE);
        }
        if (ldebugDir != null) {
            File debugFile = new File(ldebugDir, ldebugFileName);
            try {
                if (debugFile == null || !debugFile.exists() || !debugFile.isFile() || debugFile.length() == 0L) {
                    throw new IOException();
                }
                ldebugFileName = debugFile.getPath();
            }
            catch (IOException exc) {
                System.err.println("Unable to find \"" + debugFile.getPath() + "\".");
                ldebugDir = null;
            }
        }
        try {
            System.setProperty("monolog.filename", ldebugFileName);
            factory = Monolog.init();
            if (factory == null) {
                System.err.println("Error in Monolog initialization: null factory");
            } else {
                Logger dl = factory.getLogger("fr.dyade.aaa.util.debug");
                dl.log(BasicLevel.INFO, (Object)("Debug.initialize() - " + ldebugFileName));
            }
        }
        catch (Throwable exc) {
            System.err.println("Unable to instantiate monolog wrapper");
            exc.printStackTrace();
        }
    }

    public static Logger getLogger(String topic) {
        try {
            if (factory == null) {
                Debug.init();
            }
            return factory.getLogger(topic);
        }
        catch (Exception exception) {
            if (logger == null) {
                logger = new PrivateLogger();
            }
            return logger;
        }
    }

    public static void setLoggerLevel(String topic, int level) {
        Debug.getLogger(topic).setIntLevel(level);
    }

    public static void setLoggerFactory(LoggerFactory loggerFactory) {
        factory = loggerFactory;
    }

    static {
        debugDir = null;
        debugFileName = null;
        logger = null;
    }

    private static class PrivateLogger
    implements Logger {
        PrivateLogger() {
            BasicLevel.FATAL = 1000;
            BasicLevel.ERROR = 800;
            BasicLevel.WARN = 600;
            BasicLevel.INFO = 400;
            BasicLevel.DEBUG = 200;
        }

        public String getName() {
            return this.toString();
        }

        public void setName(String name) {
        }

        public String getType() {
            return "console";
        }

        public String[] getAttributeNames() {
            return null;
        }

        public Object getAttribute(String name) {
            return null;
        }

        public Object setAttribute(String name, Object value) {
            return null;
        }

        public void setIntLevel(int l) {
        }

        public void setLevel(Level l) {
        }

        public int getCurrentIntLevel() {
            return BasicLevel.ERROR;
        }

        public Level getCurrentLevel() {
            return null;
        }

        public boolean isLoggable(int level) {
            return level >= BasicLevel.ERROR;
        }

        public boolean isLoggable(Level l) {
            return l.getIntValue() >= BasicLevel.ERROR;
        }

        public boolean isOn() {
            return true;
        }

        public void log(int level, Object o) {
            if (level >= BasicLevel.ERROR) {
                System.err.println(o.toString());
            }
        }

        public void log(Level l, Object o) {
            if (l.getIntValue() >= BasicLevel.ERROR) {
                System.err.println(o.toString());
            }
        }

        public void log(int level, Object o, Throwable t) {
            if (level >= BasicLevel.ERROR) {
                System.err.println(o.toString() + ":" + t.toString());
            }
        }

        public void log(Level l, Object o, Throwable t) {
            if (l.getIntValue() >= BasicLevel.ERROR) {
                System.err.println(o.toString() + ":" + t.toString());
            }
        }

        public void log(int level, Object o, Object location, Object method) {
            if (level >= BasicLevel.ERROR) {
                System.err.println(location.toString() + Debug.DEFAULT_DEBUG_DIR + method.toString() + "(...) :" + o.toString());
            }
        }

        public void log(Level l, Object o, Object location, Object method) {
            if (l.getIntValue() >= BasicLevel.ERROR) {
                System.err.println(location.toString() + Debug.DEFAULT_DEBUG_DIR + method.toString() + "(...) :" + o.toString());
            }
        }

        public void log(int level, Object o, Throwable t, Object location, Object method) {
            if (level >= BasicLevel.ERROR) {
                System.err.println(location.toString() + Debug.DEFAULT_DEBUG_DIR + method.toString() + "(...) :" + o.toString() + " " + t.toString());
            }
        }

        public void log(Level l, Object o, Throwable t, Object location, Object method) {
            if (l.getIntValue() >= BasicLevel.ERROR) {
                System.err.println(location.toString() + Debug.DEFAULT_DEBUG_DIR + method.toString() + "(...) :" + o.toString() + " " + t.toString());
            }
        }

        public void turnOn() {
        }

        public void turnOff() {
        }

        public String toString() {
            return "Private ScalAgent D.T. default implementation";
        }
    }
}

