/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.ser.BeanDeserializer;
import org.apache.axis.encoding.ser.BeanSerializer;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedQName;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.ReferenceParametersType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.message.addressing.ServiceNameType;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.types.URI;
import org.apache.axis.utils.XMLUtils;

public class EndpointReferenceType
implements AnyContentType,
Serializable {
    private AttributedURI m_address;
    private AttributedQName m_portType;
    private ServiceNameType m_serviceName;
    private ReferencePropertiesType m_properties = new ReferencePropertiesType();
    private ReferenceParametersType m_parameters = new ReferenceParametersType();
    private MessageElement[] m_any;
    private static TypeDesc typeDesc = new TypeDesc(class$org$apache$axis$message$addressing$EndpointReferenceType == null ? (class$org$apache$axis$message$addressing$EndpointReferenceType = EndpointReferenceType.class$("org.apache.axis.message.addressing.EndpointReferenceType")) : class$org$apache$axis$message$addressing$EndpointReferenceType, true);
    static /* synthetic */ Class class$org$apache$axis$message$addressing$EndpointReferenceType;

    public EndpointReferenceType() {
    }

    public EndpointReferenceType(URI address) {
        this.m_address = new AttributedURI(address);
    }

    public EndpointReferenceType(Address address) {
        this.m_address = address;
    }

    public EndpointReferenceType(EndpointReferenceType endpoint) {
        this(endpoint, false);
    }

    public EndpointReferenceType(EndpointReferenceType endpoint, boolean deepCopy) {
        if (deepCopy) {
            this.deepCopy(endpoint);
        } else {
            this.shallowCopy(endpoint);
        }
    }

    private void shallowCopy(EndpointReferenceType endpoint) {
        MessageElement[] any;
        ReferenceParametersType parameters;
        this.setAddress(endpoint.getAddress());
        this.setPortType(endpoint.getPortType());
        this.setServiceName(endpoint.getServiceName());
        ReferencePropertiesType properties = endpoint.getProperties();
        if (properties != null) {
            this.setProperties(new ReferencePropertiesType(properties, false));
        }
        if ((parameters = endpoint.getParameters()) != null) {
            this.setParameters(new ReferenceParametersType(parameters, false));
        }
        if ((any = endpoint.get_any()) != null && any.length > 0) {
            MessageElement[] newAny = new MessageElement[any.length];
            System.arraycopy(any, 0, newAny, 0, any.length);
            this.set_any(newAny);
        }
    }

    private void deepCopy(EndpointReferenceType endpoint) {
        ReferenceParametersType parameters;
        ReferencePropertiesType properties;
        ServiceNameType serviceName;
        AttributedQName port;
        AttributedURI address = endpoint.getAddress();
        if (address != null) {
            this.setAddress(new AttributedURI(address));
        }
        if ((port = endpoint.getPortType()) != null) {
            this.setPortType(new AttributedQName(port));
        }
        if ((serviceName = endpoint.getServiceName()) != null) {
            this.setServiceName(new ServiceNameType(serviceName));
        }
        if ((properties = endpoint.getProperties()) != null) {
            this.setProperties(new ReferencePropertiesType(properties, true));
        }
        if ((parameters = endpoint.getParameters()) != null) {
            this.setParameters(new ReferenceParametersType(parameters, true));
        }
        MessageElement elem = null;
        MessageElement[] any = endpoint.get_any();
        if (any != null) {
            MessageElement[] newAny = new MessageElement[any.length];
            for (int i = 0; i < any.length; ++i) {
                elem = any[i];
                try {
                    newAny[i] = new MessageElement(elem.getAsDOM());
                    continue;
                }
                catch (Exception e) {
                    newAny[i] = elem;
                }
            }
            this.set_any(newAny);
        }
    }

    public AttributedURI getAddress() {
        return this.m_address;
    }

    public void setAddress(AttributedURI address) {
        this.m_address = address;
    }

    public AttributedQName getPortType() {
        return this.m_portType;
    }

    public void setPortType(AttributedQName portType) {
        this.m_portType = portType;
    }

    public ReferencePropertiesType getProperties() {
        return this.m_properties;
    }

    public void setProperties(ReferencePropertiesType properties) {
        this.m_properties = properties;
    }

    public ReferenceParametersType getParameters() {
        return this.m_parameters;
    }

    public void setParameters(ReferenceParametersType parameters) {
        this.m_parameters = parameters;
    }

    public ServiceNameType getServiceName() {
        return this.m_serviceName;
    }

    public void setServiceName(ServiceNameType serviceName) {
        this.m_serviceName = serviceName;
    }

    public MessageElement[] get_any() {
        return this.m_any;
    }

    public void set_any(MessageElement[] _any) {
        this.m_any = _any;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.m_address != null) {
            buf.append("Address: " + this.m_address);
            buf.append("\n");
        }
        if (this.m_portType != null) {
            buf.append("Port Type: " + this.m_portType);
            buf.append("\n");
        }
        if (this.m_serviceName != null) {
            buf.append("Service Name: " + this.m_serviceName);
            buf.append("\n");
            if (this.m_serviceName.getPort() != null) {
                buf.append("Port Name: " + this.m_serviceName.getPort());
                buf.append("\n");
            }
        }
        if (this.m_properties != null) {
            buf.append(this.m_properties);
        }
        if (this.m_any != null) {
            for (int i = 0; i < this.m_any.length; ++i) {
                buf.append("Extensibility Element[" + i + "]:\n");
                try {
                    buf.append(XMLUtils.ElementToString(this.m_any[i].getAsDOM()));
                }
                catch (Exception e) {
                    buf.append("<error converting: " + e.getMessage() + ">");
                }
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    public static TypeDesc getTypeDesc() {
        return typeDesc;
    }

    public static Serializer getSerializer(String mechType, Class _javaType, QName _xmlType) {
        return new BeanSerializer(_javaType, _xmlType, typeDesc);
    }

    public static Deserializer getDeserializer(String mechType, Class _javaType, QName _xmlType) {
        return new BeanDeserializer(_javaType, _xmlType, typeDesc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        typeDesc.setXmlType(new QName(AddressingUtils.getAddressingNamespaceURI(), "EndpointReferenceType"));
        ElementDesc elemField = new ElementDesc();
        elemField.setFieldName("address");
        elemField.setXmlName(new QName(AddressingUtils.getAddressingNamespaceURI(), "Address"));
        elemField.setXmlType(new QName(AddressingUtils.getAddressingNamespaceURI(), "AttributedURI"));
        typeDesc.addFieldDesc(elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("properties");
        elemField.setXmlName(new QName(AddressingUtils.getAddressingNamespaceURI(), "ReferenceProperties"));
        elemField.setXmlType(new QName(AddressingUtils.getAddressingNamespaceURI(), "ReferencePropertiesType"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc(elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("parameters");
        elemField.setXmlName(new QName(AddressingUtils.getAddressingNamespaceURI(), "ReferenceParameters"));
        elemField.setXmlType(new QName(AddressingUtils.getAddressingNamespaceURI(), "ReferenceParametersType"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc(elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("portType");
        elemField.setXmlName(new QName(AddressingUtils.getAddressingNamespaceURI(), "PortType"));
        elemField.setXmlType(new QName(AddressingUtils.getAddressingNamespaceURI(), "AttributedQName"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc(elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("serviceName");
        elemField.setXmlName(new QName(AddressingUtils.getAddressingNamespaceURI(), "ServiceName"));
        elemField.setXmlType(new QName(AddressingUtils.getAddressingNamespaceURI(), "ServiceNameType"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc(elemField);
    }
}

