/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.auth.Authenticator;
import org.apache.juddi.auth.AuthenticatorFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.GetAuthToken;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnknownUserException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class GetAuthTokenFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$function$GetAuthTokenFunction == null ? (class$org$apache$juddi$function$GetAuthTokenFunction = GetAuthTokenFunction.class$("org.apache.juddi.function.GetAuthTokenFunction")) : class$org$apache$juddi$function$GetAuthTokenFunction);
    static /* synthetic */ Class class$org$apache$juddi$function$GetAuthTokenFunction;

    public GetAuthTokenFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        GetAuthToken request = (GetAuthToken)regObject;
        String generic = request.getGeneric();
        String userID = request.getUserID();
        String cred = request.getCredential();
        DataStore dataStore = DataStoreFactory.getDataStore();
        Authenticator authenticator = AuthenticatorFactory.getAuthenticator();
        try {
            dataStore.beginTrans();
            String publisherID = authenticator.authenticate(userID, cred);
            if (publisherID == null) {
                throw new UnknownUserException("get_authToken: userID=" + userID);
            }
            Publisher publisher = dataStore.getPublisher(publisherID);
            if (publisher == null) {
                throw new UnknownUserException("get_authToken: userID=" + userID);
            }
            String token = dataStore.generateToken(publisher);
            dataStore.storeAuthToken(token, publisher);
            dataStore.commit();
            AuthToken authToken = new AuthToken();
            authToken.setGeneric(generic);
            authToken.setOperator(Config.getOperator());
            authToken.setAuthInfo(new AuthInfo(token));
            AuthToken authToken2 = authToken;
            return authToken2;
        }
        catch (UnknownUserException ukuex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info(ukuex.getMessage());
            throw ukuex;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        try {
            GetAuthToken request = new GetAuthToken("sviens", "password");
            AuthToken response = (AuthToken)new GetAuthTokenFunction(reg).execute(request);
            System.out.println("Function: getAuthToken(sviens/password)");
            System.out.println(" AuthInfo: " + response.getAuthInfo());
            request = new GetAuthToken("jdoe", "password");
            System.out.println("Function: getAuthToken(jdoe/password)");
            response = (AuthToken)new GetAuthTokenFunction(reg).execute(request);
            System.out.println(" AuthInfo: " + response.getAuthInfo());
            request = new GetAuthToken("guest", "password");
            System.out.println("Function: getAuthToken(guest/password)");
            response = (AuthToken)new GetAuthTokenFunction(reg).execute(request);
            System.out.println(" AuthInfo: " + response.getAuthInfo());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            reg.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

