/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.GetAuthToken;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class GetAuthTokenHandler
extends AbstractHandler {
    public static final String TAG_NAME = "get_authToken";
    private HandlerMaker maker = null;

    protected GetAuthTokenHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        String generic;
        String credential;
        GetAuthToken obj = new GetAuthToken();
        String userID = element.getAttribute("userID");
        if (userID != null && userID.trim().length() > 0) {
            obj.setUserID(userID);
        }
        if ((credential = element.getAttribute("cred")) != null && credential.trim().length() > 0) {
            obj.setCredential(credential);
        }
        if ((generic = element.getAttribute("generic")) != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String generic;
        String userID;
        GetAuthToken request = (GetAuthToken)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        String cred = request.getCredential();
        if (cred != null && cred.length() > 0) {
            element.setAttribute("cred", cred);
        }
        if ((userID = request.getUserID()) != null && userID.length() > 0) {
            element.setAttribute("userID", userID);
        }
        if ((generic = request.getGeneric()) != null) {
            element.setAttribute("generic", generic);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        GetAuthToken request = new GetAuthToken();
        request.setUserID("sviens");
        request.setCredential("password");
        System.out.println();
        RegistryObject regObject = request;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

