/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Deltree
extends Task {
    private File dir;

    public void setDir(File dir2) {
        this.dir = dir2;
    }

    public void execute() throws BuildException {
        this.log("DEPRECATED - The deltree task is deprecated.  Use delete instead.");
        if (this.dir == null) {
            throw new BuildException("dir attribute must be set!", this.getLocation());
        }
        if (this.dir.exists()) {
            if (!this.dir.isDirectory()) {
                if (!this.dir.delete()) {
                    throw new BuildException("Unable to delete directory " + this.dir.getAbsolutePath(), this.getLocation());
                }
                return;
            }
            this.log("Deleting: " + this.dir.getAbsolutePath());
            try {
                this.removeDir(this.dir);
            }
            catch (IOException ioe) {
                String msg = "Unable to delete " + this.dir.getAbsolutePath();
                throw new BuildException(msg, this.getLocation());
            }
        }
    }

    private void removeDir(File dir2) throws IOException {
        String[] list = dir2.list();
        int i = 0;
        while (i < list.length) {
            String s = list[i];
            File f = new File(dir2, s);
            if (f.isDirectory()) {
                this.removeDir(f);
            } else if (!f.delete()) {
                throw new BuildException("Unable to delete file " + f.getAbsolutePath());
            }
            ++i;
        }
        if (!dir2.delete()) {
            throw new BuildException("Unable to delete directory " + dir2.getAbsolutePath());
        }
    }
}

