/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.conversation;

import java.util.HashMap;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.sandbox.security.conversation.ConvEngineResult;
import org.apache.ws.sandbox.security.conversation.ConversationException;
import org.apache.ws.sandbox.security.conversation.ConversationUtil;
import org.apache.ws.sandbox.security.conversation.DerivedKeyCallbackHandler;
import org.apache.ws.sandbox.security.conversation.message.info.DerivedKeyInfo;
import org.apache.ws.sandbox.security.conversation.message.info.SecurityContextInfo;
import org.apache.ws.sandbox.security.conversation.message.token.DerivedKeyToken;
import org.apache.ws.sandbox.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.sandbox.security.trust.TrustEngine;
import org.apache.ws.sandbox.security.trust.WSTrustException;
import org.apache.ws.sandbox.security.trust.message.token.RequestSecurityTokenResponse;
import org.apache.ws.sandbox.security.trust.message.token.RequestedProofToken;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.Loader;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ConversationEngine {
    private static Log log = LogFactory.getLog((class$org$apache$ws$sandbox$security$conversation$ConversationEngine == null ? (class$org$apache$ws$sandbox$security$conversation$ConversationEngine = ConversationEngine.class$("org.apache.ws.sandbox.security.conversation.ConversationEngine")) : class$org$apache$ws$sandbox$security$conversation$ConversationEngine).getName());
    private static Log tlog = LogFactory.getLog("org.apache.ws.security.TIME");
    private boolean doDebug = false;
    protected static final QName DERIVEDKEY_TOKEN = new QName("http://schemas.xmlsoap.org/ws/2005/02/sc", "DerivedKeyToken");
    protected static final QName SCT_TOKEN = new QName("http://schemas.xmlsoap.org/ws/2005/02/sc", "SecurityContextToken");
    protected static final QName REQUESTED_SECURITY_TOKEN_RESPONSE = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestSecurityTokenResponse");
    protected static final QName SIGNATURE = new QName("http://www.w3.org/2000/09/xmldsig#", "Signature");
    protected static final QName REFERENCE_LIST = new QName("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
    protected static final QName SCT = SecurityContextToken.TOKEN;
    protected HashMap configurator = new HashMap();
    protected String trustPropFile = null;
    protected boolean verifyTrust = false;
    protected WSSConfig wssConfig = WSSConfig.getDefaultWSConfig();
    static /* synthetic */ Class class$org$apache$ws$sandbox$security$conversation$ConversationEngine;

    public ConversationEngine(HashMap config) {
        this.configurator = config;
        Boolean bool = null;
        bool = (Boolean)this.configurator.get("verifyTrust");
        if (bool != null) {
            this.verifyTrust = bool;
            if (this.verifyTrust) {
                this.trustPropFile = (String)this.configurator.get("trustEngineProperties");
            }
        }
    }

    public Vector processSecConvHeader(Document doc, String actor, DerivedKeyCallbackHandler dkcb, String callback) throws ConversationException {
        NodeList list;
        int len;
        this.doDebug = log.isDebugEnabled();
        if (this.doDebug) {
            log.debug("enter processSecurityHeader()");
        }
        if (actor == null) {
            actor = "";
        }
        if ((len = (list = doc.getElementsByTagNameNS(WSConstants.WSSE_NS, "Security")).getLength()) == 0) {
            return null;
        }
        if (this.doDebug) {
            log.debug("Found WS-Security header(s): " + len);
        }
        Element elem = null;
        Attr attr = null;
        String headerActor = null;
        SOAPConstants sc = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        Vector convResult = new Vector();
        for (int i = 0; i < len; ++i) {
            elem = (Element)list.item(i);
            attr = elem.getAttributeNodeNS(sc.getEnvelopeURI(), sc.getRoleAttributeQName().getLocalPart());
            if (attr != null) {
                headerActor = attr.getValue();
            }
            if (headerActor != null && headerActor.length() != 0 && !headerActor.equalsIgnoreCase(actor) && !headerActor.equals(sc.getNextRoleURI())) continue;
            if (this.doDebug) {
                log.debug("Processing WS-Security header for '" + actor + "' actor.");
            }
            try {
                convResult = this.processConvHeader(elem, doc, dkcb, callback);
                continue;
            }
            catch (WSSecurityException e) {
                e.printStackTrace();
                continue;
            }
            catch (ConversationException e) {
                e.printStackTrace();
            }
        }
        return convResult;
    }

    protected Vector processConvHeader(Element securityHeader, Document doc, DerivedKeyCallbackHandler dkcbHandler, String callback) throws ConversationException, WSSecurityException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        NodeList list = securityHeader.getChildNodes();
        int len = list.getLength();
        Object localName = null;
        Object namespace = null;
        if (tlog.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        Vector<ConvEngineResult> returnResults = new Vector<ConvEngineResult>();
        for (int i = 0; i < len; ++i) {
            Node elem = list.item(i);
            if (elem.getNodeType() != 1) continue;
            QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
            if (el.equals(REQUESTED_SECURITY_TOKEN_RESPONSE)) {
                if (this.doDebug) {
                    log.debug("Found RequestedSecurityTokenResponse element");
                }
                returnResults.add(this.handleRequestedSecurityTokenResponse((Element)elem, dkcbHandler, callback));
                continue;
            }
            if (el.equals(SIGNATURE)) {
                if (this.doDebug) {
                    log.debug("Found Signature element");
                }
                ConvEngineResult convResult = this.VerifySignature((Element)elem, dkcbHandler);
                returnResults.add(convResult);
                continue;
            }
            if (el.equals(REFERENCE_LIST)) {
                if (this.doDebug) {
                    log.debug("Found Reference List element");
                }
                Vector tmpVec = this.handleReferenceList((Element)elem, dkcbHandler);
                for (int j = 0; j < tmpVec.size(); ++j) {
                    returnResults.add((ConvEngineResult)tmpVec.get(j));
                }
                continue;
            }
            if (!el.equals(SCT)) continue;
            SecurityContextToken sct = new SecurityContextToken((Element)elem);
            String uuid = sct.getIdentifier();
            ConvEngineResult convResult = new ConvEngineResult(5);
            convResult.setUuid(uuid);
            returnResults.add(convResult);
        }
        return returnResults;
    }

    public ConvEngineResult handleRequestedSecurityTokenResponse(Element eleSTRes, DerivedKeyCallbackHandler dkcbHandler, String callback) throws ConversationException {
        String uuid = null;
        RequestSecurityTokenResponse stRes = null;
        try {
            if (this.verifyTrust) {
                TrustEngine trstEngine = new TrustEngine(this.trustPropFile);
                System.out.println("...........Verifying trust.........");
            }
            stRes = new RequestSecurityTokenResponse(eleSTRes, true);
            SecurityContextToken SCT = stRes.getRequestedSecurityToken().getSct();
            uuid = SCT.getIdentifier();
            RequestedProofToken proofToken = stRes.getRequestedProofToken();
            proofToken.doDecryption(callback, this.loadDecryptionCrypto());
            SecurityContextInfo scInfo = null;
            scInfo = new SecurityContextInfo(SCT, proofToken, 1);
            DerivedKeyCallbackHandler.addSecurtiyContext(uuid, scInfo);
            DerivedKeyCallbackHandler.setDerivedKeyLength(uuid, (Long)this.configurator.get("keyLegnth"));
            log.debug(" Done SecurityToekenResponse Handled");
            ConvEngineResult res = new ConvEngineResult(1);
            res.setUuid(uuid);
            return res;
        }
        catch (WSTrustException e) {
            e.printStackTrace();
            throw new ConversationException("");
        }
        catch (WSSecurityException e) {
            e.printStackTrace();
            throw new ConversationException("");
        }
    }

    private ConvEngineResult VerifySignature(Element elem, DerivedKeyCallbackHandler dkcbHandler) throws ConversationException {
        ConvEngineResult convResult = null;
        XMLSignature sig = null;
        try {
            sig = new XMLSignature(elem, null);
        }
        catch (XMLSignatureException e2) {
            throw new ConversationException("noXMLSig");
        }
        catch (XMLSecurityException e2) {
            throw new ConversationException("noXMLSig");
        }
        String sigMethodURI = sig.getSignedInfo().getSignatureMethodURI();
        if (sigMethodURI.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
            try {
                convResult = this.verifiyXMLHMac_SHA1_Signarue(sig, dkcbHandler);
            }
            catch (WSSecurityException e) {
                e.printStackTrace();
            }
        } else {
            throw new ConversationException("Failed");
        }
        return convResult;
    }

    private Vector handleReferenceList(Element elem, DerivedKeyCallbackHandler dkcbHandler) throws WSSecurityException {
        Vector<ConvEngineResult> results = new Vector<ConvEngineResult>();
        Document doc = elem.getOwnerDocument();
        Node tmpE = null;
        for (tmpE = elem.getFirstChild(); tmpE != null; tmpE = tmpE.getNextSibling()) {
            if (tmpE.getNodeType() != 1 || !tmpE.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#")) continue;
            if (tmpE.getLocalName().equals("DataReference")) {
                String dataRefURI = ((Element)tmpE).getAttribute("URI");
                ConvEngineResult convRes = this.decryptDataRef(doc, dataRefURI, dkcbHandler);
                results.add(convRes);
                continue;
            }
            if (!tmpE.getLocalName().equals("KeyReference")) continue;
            String keyRefURI = ((Element)tmpE).getAttribute("URI");
        }
        return results;
    }

    private ConvEngineResult decryptDataRef(Document doc, String dataRefURI, DerivedKeyCallbackHandler dkcbHandler) throws WSSecurityException {
        log.debug("ConversationEngine :: Found data refernce: " + dataRefURI);
        ConvEngineResult convResult = null;
        Element encBodyData = null;
        encBodyData = WSSecurityUtil.getElementByWsuId(WSSConfig.getDefaultWSConfig(), doc, dataRefURI);
        if (encBodyData == null) {
            encBodyData = WSSecurityUtil.getElementByGenId(doc, dataRefURI);
        }
        if (encBodyData == null) {
            throw new WSSecurityException(3, "dataRef", new Object[]{dataRefURI});
        }
        Element tmpE = null;
        log.debug("ConversationEngine :: Going to figure out the key to decrypt");
        byte[] decryptedBytes = null;
        log.debug("ConversationEngine:: Going to look for SecurityTokenReference");
        tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "SecurityTokenReference", WSSConfig.getDefaultWSConfig().getWsseNS());
        if (tmpE != null) {
            SecurityTokenReference secRef = new SecurityTokenReference(WSSConfig.getDefaultWSConfig(), tmpE);
            try {
                convResult = this.handleSecurityTokenReference(secRef, dkcbHandler);
                decryptedBytes = convResult.getKeyAssociated();
            }
            catch (ConversationException e2) {
                e2.printStackTrace();
            }
        } else {
            throw new WSSecurityException(0);
        }
        String symEncAlgo = this.getEncAlgo(encBodyData);
        SecretKey symmetricKey = WSSecurityUtil.prepareSecretKey(symEncAlgo, decryptedBytes);
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance(symEncAlgo);
            xmlCipher.init(2, symmetricKey);
        }
        catch (XMLEncryptionException e1) {
            throw new WSSecurityException(2, null, null, e1);
        }
        WSSecurityEngine eng = new WSSecurityEngine();
        boolean content = this.isContent(encBodyData);
        if (content) {
            encBodyData = (Element)encBodyData.getParentNode();
        } else {
            System.out.println("Not content:-)");
        }
        try {
            xmlCipher.doFinal(doc, encBodyData, content);
        }
        catch (Exception e) {
            throw new WSSecurityException(8, null, null, e);
        }
        return convResult;
    }

    public ConvEngineResult handleSecurityTokenReference(SecurityTokenReference secRef2DkToken, DerivedKeyCallbackHandler dkcbHandler) throws ConversationException {
        if (secRef2DkToken.containsReference()) {
            Reference ref = null;
            try {
                ref = secRef2DkToken.getReference();
            }
            catch (WSSecurityException e1) {
                e1.printStackTrace();
                throw new ConversationException(e1.getMessage());
            }
            String valueType = ref.getValueType();
            if (valueType.equals("http://schemas.xmlsoap.org/ws/2005/02/sc/dk")) {
                DerivedKeyToken dkToken;
                String uuid;
                block17: {
                    Element ele = WSSecurityUtil.getElementByWsuId(WSSConfig.getDefaultWSConfig(), secRef2DkToken.getElement().getOwnerDocument(), ref.getURI());
                    if (ele == null) {
                        throw new ConversationException("Cannot find  referenced Derived Key");
                    }
                    uuid = null;
                    dkToken = null;
                    try {
                        dkToken = new DerivedKeyToken(ele);
                        if (dkToken.getSecuityTokenReference() == null) {
                            SecurityContextToken secContextTk = ConversationUtil.getSCT(dkToken);
                            uuid = secContextTk.getIdentifier();
                            log.debug("ConversationEngine :: The uuid is found " + uuid);
                            DerivedKeyInfo dkInfo = new DerivedKeyInfo(dkToken);
                            dkcbHandler.addDerivedKey(uuid, dkInfo);
                            break block17;
                        }
                        SecurityTokenReference str2Base = dkToken.getSecuityTokenReference();
                        if (str2Base.containsReference()) {
                            Reference ref2Base = str2Base.getReference();
                            if (ref2Base.getValueType().equals("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-saml-token-profile-1.0#SAMLAssertionID")) {
                                uuid = ref2Base.getURI();
                                if (DerivedKeyCallbackHandler.getSession(uuid) == null) {
                                    byte[] key = this.handleSAML(ref2Base.getElement().getOwnerDocument(), uuid);
                                    System.out.println("I am here :-)");
                                    SecurityContextInfo sctInfo = new SecurityContextInfo(uuid, key, 1);
                                    DerivedKeyCallbackHandler.addSecurtiyContext(uuid, sctInfo);
                                }
                                DerivedKeyInfo dkInfo = new DerivedKeyInfo(dkToken);
                                dkcbHandler.addDerivedKey(uuid, dkInfo);
                            }
                            break block17;
                        }
                        if (str2Base.containsKeyIdentifier()) {
                            Element elem = str2Base.getFirstElement();
                            String value = elem.getAttribute("ValueType");
                            if ("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-saml-token-profile-1.0#SAMLAssertionID".equals(value)) {
                                uuid = ((Text)elem.getChildNodes().item(0)).getNodeValue();
                                if (DerivedKeyCallbackHandler.getSession(uuid) == null) {
                                    byte[] key = this.handleSAML(elem.getOwnerDocument(), uuid);
                                    System.out.println("UUID of SAML is" + uuid);
                                    SecurityContextInfo sctInfo = new SecurityContextInfo(uuid, key, 1);
                                    DerivedKeyCallbackHandler.addSecurtiyContext(uuid, sctInfo);
                                }
                                DerivedKeyInfo dkInfo = new DerivedKeyInfo(dkToken);
                                dkcbHandler.addDerivedKey(uuid, dkInfo);
                            }
                            break block17;
                        }
                        throw new ConversationException("Cannot handle this type of security token reference: " + dkToken.getSecuityTokenReference().getReference().getValueType());
                    }
                    catch (WSSecurityException e2) {
                        e2.printStackTrace();
                    }
                    catch (ConversationException e2) {
                        e2.printStackTrace();
                    }
                }
                String identifier = ConversationUtil.generateIdentifier(uuid, dkToken.getID());
                WSPasswordCallback pwCb = new WSPasswordCallback(identifier, 0);
                Callback[] callbacks = new Callback[]{pwCb};
                try {
                    dkcbHandler.handle(callbacks);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                byte[] arr = pwCb.getKey();
                ConvEngineResult res = new ConvEngineResult(3);
                res.setKeyAssociated(arr);
                return res;
            }
            throw new ConversationException("ConversationEngine :: SecurityTokenRerence doesn't contain DerivedKeys");
        }
        throw new ConversationException("ConversationEngine ::SecurityTokenRerence doesn't contain refernce");
    }

    private ConvEngineResult verifiyXMLHMac_SHA1_Signarue(XMLSignature sig, DerivedKeyCallbackHandler dkcbHandler) throws WSSecurityException {
        ConvEngineResult convResult;
        block30: {
            log.debug("Verifying HMAC-SHA1 Signature......");
            String userName = null;
            long t0 = 0L;
            long t1 = 0L;
            long t2 = 0L;
            if (tlog.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
            }
            convResult = null;
            if (sig == null) {
                throw new WSSecurityException(4, "XMLSignature object is null");
            }
            sig.addResourceResolver(EnvelopeIdResolver.getInstance(WSSConfig.getDefaultWSConfig()));
            KeyInfo info = sig.getKeyInfo();
            if (info == null) {
                throw new WSSecurityException(3, "unsupportedKeyInfo");
            }
            Node node = WSSecurityUtil.getDirectChild(info.getElement(), "SecurityTokenReference", this.wssConfig.getWsseNS());
            if (node == null) {
                throw new WSSecurityException(3, "unsupportedKeyInfo");
            }
            SecurityTokenReference secRef = new SecurityTokenReference(WSSConfig.getDefaultWSConfig(), (Element)node);
            Document docSig = sig.getDocument();
            int docHash = docSig.hashCode();
            if (this.doDebug) {
                log.debug("XML Verify doc: " + docHash);
            }
            WSDocInfo wsDocInfo = WSDocInfoStore.lookup(docHash);
            if (secRef.containsReference()) {
                Element token = secRef.getTokenElement(sig.getDocument(), wsDocInfo);
                QName el = new QName(token.getNamespaceURI(), token.getLocalName());
                if (el.equals(DERIVEDKEY_TOKEN)) {
                    DerivedKeyToken dkToken = new DerivedKeyToken(token);
                    DerivedKeyInfo dkInfo = null;
                    String uuid = null;
                    try {
                        if (dkToken.getSecuityTokenReference() == null) {
                            SecurityContextToken secContextTk = ConversationUtil.getSCT(dkToken);
                            uuid = secContextTk.getIdentifier();
                            log.debug("ConversationEngine :: The uuid is found " + uuid);
                            dkInfo = new DerivedKeyInfo(dkToken);
                            dkcbHandler.addDerivedKey(uuid, dkInfo);
                        } else {
                            SecurityTokenReference str2Base = dkToken.getSecuityTokenReference();
                            if (str2Base.containsReference()) {
                                Reference ref2Base = str2Base.getReference();
                                if (ref2Base.getValueType().equals("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-saml-token-profile-1.0#SAMLAssertionID")) {
                                    uuid = ref2Base.getURI();
                                    if (DerivedKeyCallbackHandler.getSession(uuid) == null) {
                                        byte[] key = this.handleSAML(docSig, uuid);
                                        System.out.println("I am here :-)");
                                        SecurityContextInfo sctInfo = new SecurityContextInfo(uuid, key, 1);
                                        DerivedKeyCallbackHandler.addSecurtiyContext(uuid, sctInfo);
                                    }
                                    dkInfo = new DerivedKeyInfo(dkToken);
                                    dkcbHandler.addDerivedKey(uuid, dkInfo);
                                }
                            } else if (str2Base.containsKeyIdentifier()) {
                                Element elem = str2Base.getFirstElement();
                                String value = elem.getAttribute("ValueType");
                                if ("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-saml-token-profile-1.0#SAMLAssertionID".equals(value)) {
                                    uuid = ((Text)elem.getChildNodes().item(0)).getNodeValue();
                                    if (DerivedKeyCallbackHandler.getSession(uuid) == null) {
                                        byte[] key = this.handleSAML(elem.getOwnerDocument(), uuid);
                                        System.out.println("UUID of SAML is" + uuid);
                                        SecurityContextInfo sctInfo = new SecurityContextInfo(uuid, key, 1);
                                        DerivedKeyCallbackHandler.addSecurtiyContext(uuid, sctInfo);
                                    }
                                    dkInfo = new DerivedKeyInfo(dkToken);
                                    dkcbHandler.addDerivedKey(uuid, dkInfo);
                                }
                            } else {
                                throw new ConversationException("Don't know how to process here");
                            }
                        }
                        String dkId = dkToken.getID();
                        userName = ConversationUtil.generateIdentifier(uuid, dkId);
                        convResult = new ConvEngineResult(2);
                        dkcbHandler.addDerivedKey(uuid, dkInfo);
                        log.debug("ConversationEngine: added for signature varification. uuil:" + uuid + " id:" + dkId);
                    }
                    catch (ConversationException e) {
                        e.printStackTrace();
                    }
                    catch (WSSecurityException e2) {
                        e2.printStackTrace();
                    }
                } else {
                    if (el.equals(SCT_TOKEN)) {
                        throw new WSSecurityException(3, "SCT is not Yet supported", new Object[]{el.toString()});
                    }
                    throw new WSSecurityException(3, "unsupportedToken", new Object[]{el.toString()});
                }
                if (tlog.isDebugEnabled()) {
                    t1 = System.currentTimeMillis();
                }
                try {
                    Callback[] callbacks = new WSPasswordCallback[]{new WSPasswordCallback(userName, 0)};
                    try {
                        dkcbHandler.handle(callbacks);
                    }
                    catch (UnsupportedCallbackException e) {
                        e.printStackTrace();
                        throw new WSSecurityException(9, "password call back failed", new Object[]{e.toString()});
                    }
                    byte[] keyBytes = ((WSPasswordCallback)callbacks[0]).getKey();
                    if (keyBytes == null) {
                        throw new WSSecurityException(3, "password call bac in DerivedKeyTokenHandler failed");
                    }
                    convResult.setKeyAssociated(keyBytes);
                    SecretKeySpec symetricKey = new SecretKeySpec(keyBytes, "http://www.w3.org/2000/09/xmldsig#hmac-sha1");
                    if (sig.checkSignatureValue(symetricKey)) {
                        if (tlog.isDebugEnabled()) {
                            t2 = System.currentTimeMillis();
                            tlog.debug("Verify: total= " + (t2 - t0) + ", Find-the token refernced by wsse:Reference= " + (t1 - t0) + ", password call back & verify= " + (t2 - t1));
                        }
                        break block30;
                    }
                    throw new WSSecurityException(6);
                }
                catch (XMLSignatureException e1) {
                    throw new WSSecurityException(6);
                }
            }
        }
        return convResult;
    }

    private String getEncAlgo(Node encBodyData) throws WSSecurityException {
        Element tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        String symEncAlgo = null;
        if (tmpE != null) {
            symEncAlgo = tmpE.getAttribute("Algorithm");
        }
        if (symEncAlgo == null) {
            throw new WSSecurityException(2, "noEncAlgo");
        }
        if (this.doDebug) {
            log.debug("Sym Enc Algo: " + symEncAlgo);
        }
        return symEncAlgo;
    }

    private Crypto loadDecryptionCrypto() {
        Crypto crypto = null;
        String encPropFile = (String)this.configurator.get("decryptionPropFile");
        crypto = CryptoFactory.getInstance(encPropFile);
        return crypto;
    }

    private byte[] handleSAML(Document doc, String assertionId) throws ConversationException {
        try {
            Crypto crypto = this.loadDecryptionCrypto();
            Element ele = WSSecurityUtil.findWsseSecurityHeaderBlock(WSSConfig.getDefaultWSConfig(), doc, doc.getDocumentElement(), false);
            Element samEle = (Element)WSSecurityUtil.getDirectChild(ele, "Assertion", "urn:oasis:names:tc:SAML:1.0:assertion");
            Element eleEnc = (Element)samEle.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey").item(0);
            String cb = (String)this.configurator.get("passwordCallbackClass");
            CallbackHandler cbHandler = null;
            if (cb != null) {
                Class cbClass = null;
                try {
                    cbClass = Loader.loadClass(cb);
                    cbHandler = (CallbackHandler)cbClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new ConversationException("Cannot find passwordcallback");
                }
                catch (InstantiationException e2) {
                    e2.printStackTrace();
                }
                catch (IllegalAccessException e2) {
                    e2.printStackTrace();
                }
            } else {
                throw new ConversationException("Cannot find passwordcallback");
            }
            WSSecurityEngine eng = new WSSecurityEngine();
            eng.handleEncryptedKey(eleEnc, cbHandler, crypto);
            byte[] key = eng.getDecryptedBytes();
            return key;
        }
        catch (WSSecurityException e1) {
            e1.printStackTrace();
            throw new ConversationException("Cannot find passwordcallback");
        }
    }

    private boolean isContent(Node encBodyData) {
        Element tmpE = (Element)WSSecurityUtil.findElement(encBodyData, "EncryptedData", "http://www.w3.org/2001/04/xmlenc#");
        String typeStr = null;
        boolean content = true;
        if (tmpE != null) {
            typeStr = tmpE.getAttribute("Type");
        }
        if (typeStr != null) {
            content = typeStr.equals("http://www.w3.org/2001/04/xmlenc#Content");
        }
        return content;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Init.init();
    }
}

