/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.OptimisticCache;

public class TransactionalCache
implements CacheConcurrencyStrategy {
    private static final Log log = LogFactory.getLog(TransactionalCache.class);
    private Cache cache;

    public String getRegionName() {
        return this.cache.getRegionName();
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("cache lookup: " + key);
        }
        Object result = this.cache.read(key);
        if (log.isDebugEnabled()) {
            log.debug(result == null ? "cache miss" : "cache hit");
        }
        return result;
    }

    public boolean put(Object key, Object value, long txTimestamp, Object version2, Comparator versionComparator, boolean minimalPut) throws CacheException {
        if (minimalPut && this.cache.read(key) != null) {
            if (log.isDebugEnabled()) {
                log.debug("item already cached: " + key);
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("caching: " + key);
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeLoad(key, value, version2);
        } else {
            this.cache.put(key, value);
        }
        return true;
    }

    public CacheConcurrencyStrategy.SoftLock lock(Object key, Object version2) throws CacheException {
        return null;
    }

    public void release(Object key, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("updating: " + key);
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeUpdate(key, value, currentVersion, previousVersion);
        } else {
            this.cache.update(key, value);
        }
        return true;
    }

    public boolean insert(Object key, Object value, Object currentVersion) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("inserting: " + key);
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeInsert(key, value, currentVersion);
        } else {
            this.cache.update(key, value);
        }
        return true;
    }

    public void evict(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void remove(Object key) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug("removing: " + key);
        }
        this.cache.remove(key);
    }

    public void clear() throws CacheException {
        log.debug("clearing");
        this.cache.clear();
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn("could not destroy cache", e);
        }
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public boolean afterInsert(Object key, Object value, Object version2) throws CacheException {
        return false;
    }

    public boolean afterUpdate(Object key, Object value, Object version2, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
        return false;
    }

    public String toString() {
        return this.cache + "(transactional)";
    }
}

