/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinderHelper {
    public static final String ANNOTATION_STRING_DEFAULT = "";
    public static final Set<String> PRIMITIVE_NAMES;

    private BinderHelper() {
    }

    public static Property shallowCopy(Property property) {
        Property clone = new Property();
        clone.setCascade(property.getCascade());
        clone.setInsertable(property.isInsertable());
        clone.setLazy(property.isLazy());
        clone.setName(property.getName());
        clone.setNodeName(property.getNodeName());
        clone.setNaturalIdentifier(property.isNaturalIdentifier());
        clone.setOptimisticLocked(property.isOptimisticLocked());
        clone.setOptional(property.isOptional());
        clone.setPersistentClass(property.getPersistentClass());
        clone.setPropertyAccessorName(property.getPropertyAccessorName());
        clone.setSelectable(property.isSelectable());
        clone.setUpdateable(property.isUpdateable());
        clone.setValue(property.getValue());
        return clone;
    }

    public static void createSyntheticPropertyReference(Ejb3JoinColumn[] columns, PersistentClass ownerEntity, PersistentClass associatedEntity, Value value, boolean inverse, ExtendedMappings mappings) {
        PersistentClass associatedClass;
        if (columns[0].isImplicit() || StringHelper.isNotEmpty(columns[0].getMappedBy())) {
            return;
        }
        int fkEnum = Ejb3JoinColumn.checkReferencedColumnsType(columns, ownerEntity, mappings);
        PersistentClass persistentClass = associatedClass = columns[0].getPropertyHolder() != null ? columns[0].getPropertyHolder().getPersistentClass() : null;
        if (2 == fkEnum) {
            Component embeddedComp;
            StringBuilder propertyNameBuffer = new StringBuilder("_");
            propertyNameBuffer.append(associatedClass.getEntityName().replace('.', '_'));
            propertyNameBuffer.append("_").append(columns[0].getPropertyName());
            String syntheticPropertyName = propertyNameBuffer.toString();
            Object columnOwner = BinderHelper.findColumnOwner(ownerEntity, columns[0].getReferencedColumn(), mappings);
            List<Property> properties = BinderHelper.findPropertiesByColumns(columnOwner, columns, mappings);
            Property synthProp = null;
            if (properties != null) {
                embeddedComp = columnOwner instanceof PersistentClass ? new Component((PersistentClass)columnOwner) : new Component((Join)columnOwner);
                embeddedComp.setEmbedded(true);
                embeddedComp.setNodeName(syntheticPropertyName);
                embeddedComp.setComponentClassName(embeddedComp.getOwner().getClassName());
                for (Property property : properties) {
                    Property clone = BinderHelper.shallowCopy(property);
                    clone.setInsertable(false);
                    clone.setUpdateable(false);
                    clone.setNaturalIdentifier(false);
                    embeddedComp.addProperty(clone);
                }
            } else {
                StringBuilder columnsList = new StringBuilder();
                columnsList.append("referencedColumnNames(");
                for (Ejb3JoinColumn column : columns) {
                    columnsList.append(column.getReferencedColumn()).append(", ");
                }
                columnsList.setLength(columnsList.length() - 2);
                columnsList.append(") ");
                if (associatedEntity != null) {
                    columnsList.append("of ").append(associatedEntity.getEntityName()).append(".").append(columns[0].getPropertyName()).append(" ");
                } else if (columns[0].getPropertyHolder() != null) {
                    columnsList.append("of ").append(columns[0].getPropertyHolder().getEntityName()).append(".").append(columns[0].getPropertyName()).append(" ");
                }
                columnsList.append("referencing ").append(ownerEntity.getEntityName()).append(" not mapped to a single property");
                throw new AnnotationException(columnsList.toString());
            }
            synthProp = new Property();
            synthProp.setName(syntheticPropertyName);
            synthProp.setNodeName(syntheticPropertyName);
            synthProp.setPersistentClass(ownerEntity);
            synthProp.setUpdateable(false);
            synthProp.setInsertable(false);
            synthProp.setValue(embeddedComp);
            synthProp.setPropertyAccessorName("embedded");
            ownerEntity.addProperty(synthProp);
            TableBinder.createUniqueConstraint(embeddedComp);
            if (value instanceof ToOne) {
                ((ToOne)value).setReferencedPropertyName(syntheticPropertyName);
                mappings.addUniquePropertyReference(ownerEntity.getEntityName(), syntheticPropertyName);
            } else if (value instanceof Collection) {
                ((Collection)value).setReferencedPropertyName(syntheticPropertyName);
                mappings.addPropertyReference(ownerEntity.getEntityName(), syntheticPropertyName);
            } else {
                throw new AssertionFailure("Do a property ref on an unexpected Value type: " + value.getClass().getName());
            }
            mappings.addPropertyReferencedAssociation((inverse ? "inverse__" : ANNOTATION_STRING_DEFAULT) + associatedClass.getEntityName(), columns[0].getPropertyName(), syntheticPropertyName);
        }
    }

    private static List<Property> findPropertiesByColumns(Object columnOwner, Ejb3JoinColumn[] columns, ExtendedMappings mappings) {
        Iterator it;
        HashMap<Column, Set<Property>> columnsToProperty = new HashMap<Column, Set<Property>>();
        ArrayList<Column> orderedColumns = new ArrayList<Column>(columns.length);
        Table referencedTable = null;
        if (columnOwner instanceof PersistentClass) {
            referencedTable = ((PersistentClass)columnOwner).getTable();
        } else if (columnOwner instanceof Join) {
            referencedTable = ((Join)columnOwner).getTable();
        } else {
            throw new AssertionFailure(columnOwner == null ? "columnOwner is null" : "columnOwner neither PersistentClass nor Join: " + columnOwner.getClass());
        }
        for (Ejb3JoinColumn column1 : columns) {
            Column column = new Column(mappings.getPhysicalColumnName(column1.getReferencedColumn(), referencedTable));
            orderedColumns.add(column);
            columnsToProperty.put(column, new HashSet());
        }
        boolean isPersistentClass = columnOwner instanceof PersistentClass;
        Iterator iterator = it = isPersistentClass ? ((PersistentClass)columnOwner).getPropertyIterator() : ((Join)columnOwner).getPropertyIterator();
        while (it.hasNext()) {
            BinderHelper.matchColumnsByProperty((Property)it.next(), columnsToProperty);
        }
        if (isPersistentClass) {
            BinderHelper.matchColumnsByProperty(((PersistentClass)columnOwner).getIdentifierProperty(), columnsToProperty);
        }
        ArrayList<Property> orderedProperties = new ArrayList<Property>();
        for (Column column : orderedColumns) {
            boolean found = false;
            for (Property property : (Set)columnsToProperty.get(column)) {
                if (property.getColumnSpan() != 1) continue;
                orderedProperties.add(property);
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return orderedProperties;
    }

    private static void matchColumnsByProperty(Property property, Map<Column, Set<Property>> columnsToProperty) {
        if (property == null) {
            return;
        }
        if ("noop".equals(property.getPropertyAccessorName()) || "embedded".equals(property.getPropertyAccessorName())) {
            return;
        }
        Iterator columnIt = property.getColumnIterator();
        while (columnIt.hasNext()) {
            Object column = columnIt.next();
            if (!columnsToProperty.containsKey(column)) continue;
            columnsToProperty.get(column).add(property);
        }
    }

    public static Property findPropertyByName(PersistentClass associatedClass, String propertyName) {
        Property property = null;
        Property idProperty = associatedClass.getIdentifierProperty();
        String idName = idProperty != null ? idProperty.getName() : null;
        try {
            if (propertyName == null || propertyName.length() == 0 || propertyName.equals(idName)) {
                property = idProperty;
            } else {
                if (propertyName.indexOf(idName + ".") == 0) {
                    property = idProperty;
                    propertyName = propertyName.substring(idName.length() + 1);
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
        }
        catch (MappingException e) {
            try {
                if (associatedClass.getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    public static String getRelativePath(PropertyHolder propertyHolder, String propertyName) {
        if (propertyHolder == null) {
            return propertyName;
        }
        String path = propertyHolder.getPath();
        String entityName = propertyHolder.getPersistentClass().getEntityName();
        if (path.length() == entityName.length()) {
            return propertyName;
        }
        return StringHelper.qualify(path.substring(entityName.length() + 1), propertyName);
    }

    public static Object findColumnOwner(PersistentClass persistentClass, String columnName, ExtendedMappings mappings) {
        if (StringHelper.isEmpty(columnName)) {
            return persistentClass;
        }
        PersistentClass current = persistentClass;
        PersistentClass result = null;
        boolean found = false;
        do {
            result = current;
            Table currentTable = current.getTable();
            try {
                mappings.getPhysicalColumnName(columnName, currentTable);
                found = true;
            }
            catch (MappingException me) {
                // empty catch block
            }
            Iterator joins = current.getJoinIterator();
            while (!found && joins.hasNext()) {
                result = joins.next();
                currentTable = ((Join)((Object)result)).getTable();
                try {
                    mappings.getPhysicalColumnName(columnName, currentTable);
                    found = true;
                }
                catch (MappingException me) {}
            }
            current = current.getSuperclass();
        } while (!found && current != null);
        return found ? result : null;
    }

    public static void makeIdGenerator(SimpleValue id, String generatorType, String generatorName, ExtendedMappings mappings, Map<String, IdGenerator> localGenerators) {
        Table table = id.getTable();
        table.setIdentifierValue(id);
        id.setIdentifierGeneratorStrategy(generatorType);
        Properties params = new Properties();
        params.setProperty("target_table", table.getName());
        if (id.getColumnSpan() == 1) {
            params.setProperty("target_column", ((Column)id.getColumnIterator().next()).getName());
        }
        if (!BinderHelper.isDefault(generatorName)) {
            boolean avoidOverriding;
            IdGenerator gen = mappings.getGenerator(generatorName, localGenerators);
            if (gen == null) {
                throw new AnnotationException("Unknown Id.generator: " + generatorName);
            }
            String identifierGeneratorStrategy = gen.getIdentifierGeneratorStrategy();
            boolean bl = avoidOverriding = identifierGeneratorStrategy.equals("identity") || identifierGeneratorStrategy.equals("seqhilo") || identifierGeneratorStrategy.equals(MultipleHiLoPerTableGenerator.class.getName());
            if (generatorType == null || !avoidOverriding) {
                id.setIdentifierGeneratorStrategy(identifierGeneratorStrategy);
            }
            for (Map.Entry<Object, Object> elt : gen.getParams().entrySet()) {
                params.setProperty((String)elt.getKey(), (String)elt.getValue());
            }
        }
        if ("assigned".equals(generatorType)) {
            id.setNullValue("undefined");
        }
        id.setIdentifierGeneratorProperties(params);
    }

    public static boolean isDefault(String annotationString) {
        return annotationString != null && annotationString.length() == 0;
    }

    static {
        HashSet<String> primitiveNames = new HashSet<String>();
        primitiveNames.add(Byte.TYPE.getName());
        primitiveNames.add(Short.TYPE.getName());
        primitiveNames.add(Integer.TYPE.getName());
        primitiveNames.add(Long.TYPE.getName());
        primitiveNames.add(Float.TYPE.getName());
        primitiveNames.add(Double.TYPE.getName());
        primitiveNames.add(Character.TYPE.getName());
        primitiveNames.add(Boolean.TYPE.getName());
        PRIMITIVE_NAMES = Collections.unmodifiableSet(primitiveNames);
    }
}

