/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ejb.packaging.JarVisitor;

public class FileZippedJarVisitor
extends JarVisitor {
    private static Log log = LogFactory.getLog(FileZippedJarVisitor.class);

    public FileZippedJarVisitor(String fileName, JarVisitor.Filter[] filters) {
        super(fileName, filters);
    }

    public FileZippedJarVisitor(URL url, JarVisitor.Filter[] filters) {
        super(url, filters);
    }

    protected void doProcessElements() throws IOException {
        JarFile jarFile;
        try {
            jarFile = new JarFile(this.jarUrl.toURI().getSchemeSpecificPart());
        }
        catch (IOException ze) {
            log.warn("Unable to find file (ignored): " + this.jarUrl, ze);
            return;
        }
        catch (URISyntaxException e) {
            log.warn("Malformed url: " + this.jarUrl, e);
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            this.addElement(entry.getName(), new BufferedInputStream(jarFile.getInputStream(entry)), new BufferedInputStream(jarFile.getInputStream(entry)));
        }
    }
}

