/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.id.enhanced.SequenceStructure;
import org.hibernate.id.enhanced.TableStructure;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;

public class SequenceStyleGenerator
implements PersistentIdentifierGenerator,
Configurable {
    private static final Log log = LogFactory.getLog(SequenceStyleGenerator.class);
    public static final String SEQUENCE_PARAM = "sequence_name";
    public static final String DEF_SEQUENCE_NAME = "hibernate_sequence";
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    public static final String OPT_PARAM = "optimizer";
    public static final String FORCE_TBL_PARAM = "force_table_use";
    public static final String VALUE_COLUMN_PARAM = "value_column";
    public static final String DEF_VALUE_COLUMN = "next_val";
    private DatabaseStructure databaseStructure;
    private Optimizer optimizer;
    private Type identifierType;

    public DatabaseStructure getDatabaseStructure() {
        return this.databaseStructure;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.identifierType = type;
        boolean forceTableUse = PropertiesHelper.getBoolean(FORCE_TBL_PARAM, params, false);
        String sequenceName = PropertiesHelper.getString(SEQUENCE_PARAM, params, DEF_SEQUENCE_NAME);
        if (sequenceName.indexOf(46) < 0) {
            String schemaName = params.getProperty("schema");
            String catalogName = params.getProperty("catalog");
            sequenceName = Table.qualify(catalogName, schemaName, sequenceName);
        }
        int initialValue = PropertiesHelper.getInt(INITIAL_PARAM, params, 1);
        int incrementSize = PropertiesHelper.getInt(INCREMENT_PARAM, params, 1);
        String valueColumnName = PropertiesHelper.getString(VALUE_COLUMN_PARAM, params, DEF_VALUE_COLUMN);
        String defOptStrategy = incrementSize <= 1 ? "none" : "pooled";
        String optimizationStrategy = PropertiesHelper.getString(OPT_PARAM, params, defOptStrategy);
        if ("none".equals(optimizationStrategy) && incrementSize > 1) {
            log.warn("config specified explicit optimizer of [none], but [increment_size=" + incrementSize + "; honoring optimizer setting");
            incrementSize = 1;
        }
        if (dialect.supportsSequences() && !forceTableUse) {
            if ("pooled".equals(optimizationStrategy) && !dialect.supportsPooledSequences()) {
                optimizationStrategy = "hilo";
            }
            this.databaseStructure = new SequenceStructure(dialect, sequenceName, initialValue, incrementSize);
        } else {
            this.databaseStructure = new TableStructure(dialect, sequenceName, valueColumnName, initialValue, incrementSize);
        }
        this.optimizer = OptimizerFactory.buildOptimizer(optimizationStrategy, this.identifierType.getReturnedClass(), incrementSize);
        this.databaseStructure.prepare(this.optimizer);
    }

    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        return this.optimizer.generate(this.databaseStructure.buildCallback(session));
    }

    public Object generatorKey() {
        return this.databaseStructure.getName();
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlCreateStrings(dialect);
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlDropStrings(dialect);
    }
}

